
#include "yagstest.h"
#include "random.h"

void 
TestPoint(pixel_buffer scrInfo, const U16 left, const U16 top, const U16 width, const U16 height)
{
	unsigned char aColor=0;
	
	//Y2DClear(scrInfo,0);
	Y2DRectFill(scrInfo,left,top,left+width-1, top+height-1,0);
	
	//Y2DPrimitives(scrInfo, Y2D_POINT, pts, npts, aColor);

	//Random aRand(1);
	r250 aRand;
	
	for (int looper = 0; looper < 120000; looper++)
	{
		Y2DSetPixel(scrInfo,left+aRand.NextDouble()*width, top+aRand.NextDouble()*height,aRand.NextDouble()*256);
	}
	
	//Random bRand(1);
	r250 bRand;
	for (int looper = 0; looper < 120000; looper++)
	{
		Y2DSetPixel(scrInfo,left+bRand.NextDouble()*width, top+bRand.NextDouble()*height,0);
	}
	
	for (int looper = 0; looper < 500000; looper++)
	{
		Y2DSetPixel(scrInfo,left+bRand.NextDouble()*width, top+bRand.NextDouble()*height,bRand.NextDouble()*256);
	}
}

long
TestPointThread(void *data)
{
	testParam *tparam = (testParam*)data;
	
	TestPoint(tparam->fScreenInfo, tparam->fFrame.left,tparam->fFrame.top,
	tparam->fFrame.Width(),tparam->fFrame.Height());
	
	return 0;
}

