#include "yagstest.h"
#include "effects.h"

static void
tstEllipse(screen_info scrInfo,const BRect frame)
{
	U08 aColor=0;
	U16 height = frame.Height();
	U16 width = frame.Width();
	U16 minor = Y2DMIN(width/2,height/2);
	
	// Clear the screen to black
	Y2DRectFill(scrInfo,frame.left,frame.top,frame.right, frame.bottom,0);
	
	for (int radius = minor; radius > 6 ; radius-=2)
	{
		Y2DEllipse(scrInfo,frame.left+width/2,frame.top+height/2, ((radius*width)/height)+1, radius+1, 255);
	}
}

void
TestEffects(screen_info scrInfo, const BRect frame)
{
	U16 height = frame.Height();
	U16 width = frame.Width();
	static screen_info * pixelBuffer=0;
	
	// Create a buffer to draw into
	if (!pixelBuffer)
	{
		pixelBuffer = Y2DCreatePixelBuffer(200, 200);	
		//TestPoint(*pixelBuffer, BRect(0,0,198,198);
	}
	

	// do the line test into the buffer
	for (unsigned short counter = 0; 
		counter < 200; 
		counter++)
	{
		Y2DVLine(*pixelBuffer, counter, 0, counter, 199, 
			(U16)((float)counter / (float)((float)200/(float)256)));
	}
	
	// Draw horizontal lines
	for (unsigned short counter = 0; 
		counter < 200; 
		counter++)
	{
		Y2DHLine(*pixelBuffer, 0, counter, 200-counter, counter, 
			counter%256);
	}
	
	// Do the pixel rain effect
	Y2DEffectPixelRain(scrInfo, *pixelBuffer); 	
	Y2DEffectRipple(scrInfo);
}

long
TestEffectsThread(void *data)
{
	testParam *tparam = (testParam*)data;
	
	TestEffects(tparam->fScreenInfo, tparam->fFrame);
	
	return 0;
}


