#ifndef RANDOM_H
#define RANDOM_H

#include "ygtypes.h"

class Random
{
public:
			Random(U32 seed = 1) : fSeed(seed) {};
	
	// Uniform distributions
	U32 	RandomLong();
	double	RandomReal();
	long	RandLong(long low, long high);
	
	// Non-uniform distributions
	U32 Poisson(double expectedVal);
	double	NegExp(double expectedVal);
	
protected:
	U32 fSeed;
	
private:

};



/*** 
	Function prototypes for R250 random number generator, 
		by W. L. Maier
***/

typedef short INT;
typedef unsigned short UINT;
typedef double	DBL;

class r250
{
public:
		r250();
		r250(UINT n);
		
		UINT Between(UINT n);
		UINT NextInt();
		double NextDouble();
		
protected:

private:
		void r250_init(UINT seed);
		UINT myrand();
	unsigned long lcgseed;
	INT r250_index;
	UINT r250_buffer[250]; 
};

#endif
