//******************************************************************************
//
//	File:		pulse.h
//
//	Description:	Header file for RAMPulse(tm)
//
//	Copyright 1994-1995, Be Incorporated. All Rights Reserved.
//
//******************************************************************************

#ifndef PULSE_H
#define PULSE_H

#ifndef _APPLICATION_H
#include <Application.h>
#endif
#ifndef _WINDOW_H
#include <Window.h>
#endif
#ifndef _BITMAP_H
#include <Bitmap.h>
#endif
#ifndef _PICTURE_BUTTON_H
#include <PictureButton.h>
#endif
#ifndef _VIEW_H
#include <View.h>
#endif

#define	kProcessorOff 200
#define kProcessorOn 	0

extern "C" int  _kget_cpu_state_(int cpu);
extern "C" int  _kset_cpu_state_(int cpu, int enabled);

class BTSCPUMonitor;
class CPUButton;

class CPUButton : public BPictureButton {

public:
			CPUButton(BTSCPUMonitor *, BRect r, const char* name, const char* label,
				   BPicture* normal, BPicture* pushed);

	void	MouseDown(BPoint);

protected:
	BTSCPUMonitor	*fMonitor;
};

class BTSCPUMonitor
{
public:
				BTSCPUMonitor(long cpuid, double aTime, BView *);
				
		void	Render(bool aTruth);
		void	Update(system_info *sysInfo, double aTime, bool aTruth);
		void	ToggleProcessor();
				
	BTSCPUMonitor *fNext;			// Who is the next CPU 
	
protected:
	BView	*fGraphPort;
	double			fThen;
	TProgressBar	*fProgressBar;
	CPUButton		*fCPUButton;
	long			fCPUID;
	
private:

};


class TPulseView : public BView {

public:
						TPulseView(BRect);
virtual					~TPulseView();

		void			AttachedToWindow();
virtual	void			Draw(BRect updateRect);

		void			AddCPUMonitor(long cpuid);
		void			Update(bool DoIt = FALSE);
virtual	void			Pulse();

		double			fThen;			// time of last udpate

private:
	system_info		fSysInfo;
	short			fCPUCount;
	BTSCPUMonitor	*fCPUMonitors;
	BBitmap			*fAnim1;
};

class TPulseWindow : public BWindow {

public:
						TPulseWindow(BRect);
		bool			QuitRequested();

protected:
		TPulseView		*fPulseView;
};

#endif
