//******************************************************************************
//
//	File:		progressbar.h
//
//	Description:	Header file for RAMPulse(tm)
//
//	Copyright 1994-1995, Be Incorporated. All Rights Reserved.
//
//******************************************************************************

#ifndef PBAR_H
#define PBAR_H

#ifndef _VIEW_H
#include <View.h>
#endif
	
typedef struct 
{
	short	shade;
	BRect	rect;
} segment;
	
#define ltgray 216
#define dkgray 80

class TProgressBar : public BView {

public:
					TProgressBar(BRect r, char* name, short initial, 
								bool warn = FALSE, short warnVal = 85);

virtual	void		Draw(BRect updateRect);

		void		Render(bool drawAll = FALSE);
		void		DrawSegment(short n);
		void		Set(short value);
inline double		PrevTick()					{ return fPrevTick; }
inline void			SetPrev(double theTick)		{ fPrevTick = theTick; } 

private:	
	segment		segments[20];
	short		fWidth;		// Width/height of bar
	short		fCurrent;	// Int from 1-100
	short		fPrevious;	// Int from 1-100
	double		fPrevTick;	// Last CPU idle thread time
	bool		fWarning;	
	short		fWarnVal;	// Change bar color if over fWarnValue
};

#endif
