#ifndef MAIN_H
#define MAIN_H

#ifndef _VIEW_H
#include <View.h>
#endif
#ifndef _WINDOW_H
#include <Window.h>
#endif
#ifndef _APPLICATION_H
#include <Application.h>
#endif
#ifndef _LIST_VIEW_H
#include <ListView.h>
#endif
#ifndef _SCROLL_VIEW_H
#include <ScrollView.h>
#endif
#ifndef _SCROLL_BAR_H
#include <ScrollBar.h>
#endif
#ifndef _BUTTON_H
#include <Button.h>
#endif
#ifndef _BITMAP_H
#include <Bitmap.h>
#endif
#ifndef _TEXT_VIEW_H
#include <TextView.h>
#endif
#ifndef _STRING_VIEW_H
#include <StringView.h>
#endif
#include <OS.h>

#include <string.h>
#include <stdlib.h>

/*------------------------------------------------------------*/

#define	RUN_THROUGH	101

#define NEW_SIZE	0x1000
#define NEW_SHEAR	0x1002
#define NEW_ROTATION	0x1003
#define NEW_TEXT	0x1004
#define NEW_FONT	0x1005
#define NEW_SET		0x1006

#define BUTTON_NAME	"RunThrough"

/*------------------------------------------------------------*/

short		numFonts = 0;
font_name*	fontNames = NIL;
short		numSets = 0;
symbol_set_name*	fontSets = NIL;

char*		sampleText = "Be Inc.";
short		maxLength = 255;

const BRect	mw_rect(80, 30, 490, 300);
const BRect	cw_rect(500, 30, 700, 480);
#define mw_sizeH (mw_rect.right - mw_rect.left)
#define mw_sizeV (mw_rect.bottom - mw_rect.top)
const long	FONT_NAME_HEIGHT = 13;

class		TMainWindow;
TMainWindow* 	font_window = NIL;

class		TControlWindow;
TControlWindow*	ctrl_window = NIL;

BListView*	font_list;
BListView*	set_list;

BBitmap*	the_offscreen = NIL;

//------------------------------------------------------------------------------

class TControlWindow : public BWindow
{
public:
				TControlWindow(BWindow *main_window, BRect bound,
					window_type type, ulong flags, const char *name);
virtual	void	MessageReceived(BMessage* msg);
virtual	void	DispatchMessage(BMessage* msg, BHandler *handler);

		long	control_sem;
private:
		bool	fAutoCycle;
		long	fCyclePhase;
};

//------------------------------------------------------------------------------

class TControlScroller : public BScrollBar
{

public:
					TControlScroller(BRect view_bound, BWindow *target,
						ulong command, BStringView *string_view,
						long min, long max);
virtual	void		ValueChanged(long v);

private:
		BWindow		*fTarget;
		ulong		fCommand;
		BStringView	*fStringView;
};

/*------------------------------------------------------------*/

class TMyTEView : public BTextView
{

public:
				TMyTEView(const char *name, BRect view_bound, 
					  long view_flags, BRect dest_rect);
virtual	bool	AcceptsChar(ulong aChar) const;
virtual	void	KeyDown(ulong aChar);
};

/*------------------------------------------------------------*/

class TFontView : public BView
{

public:
				TFontView(BRect view_bound);
virtual	void	Draw(BRect update_rect);
		void	SetText(const char *text);

private:
		char	*fText;
};
		
/*------------------------------------------------------------*/

class TMainView : public BView
{

public:
				TMainView(BRect bound, const char* name);
virtual	void	Draw(BRect update_rect);
};
		
/*------------------------------------------------------------*/

class TFontApp : public BApplication
{
public:
				TFontApp();
virtual	void	AboutRequested();
virtual	bool	QuitRequested();
};

/*------------------------------------------------------------*/

class TMainWindow : public BWindow
{
public:
		
					TMainWindow(BRect bound, window_type type, long flags,
						const char *name);
virtual				~TMainWindow();
virtual	void		MessageReceived(BMessage* an_event);
//geb(
virtual	void		FrameResized(float new_width, float new_height);
//)geb
virtual	bool		QuitRequested();
		void		Redraw(bool forceCache = FALSE);

private:
		TFontView* 	fFontView;
		TMainView*	fMainView;
};

#endif
