//--------------------------------------------------------------------
//	
//	FontChartWindow.cpp
//
//	Written by: Robert Polic
//	
//	Copyright 1997 Be, Inc. All Rights Reserved.
//	
//--------------------------------------------------------------------

#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>

#ifndef _DEBUG_H
#include <Debug.h>
#endif

#ifndef FONT_CHART_WINDOW_H
#include "FontChartWindow.h"
#endif

extern		TChartView	*chartView;
extern		TTableView	*tableView;

//====================================================================

TChartWindow	*chartWind;

TChartWindow::TChartWindow(BRect rect, char *title)
	          :BWindow(rect, title, B_TITLED_WINDOW, B_NOT_RESIZABLE | B_WILL_ACCEPT_FIRST_CLICK | B_NOT_ZOOMABLE)
{
	char		fontName[256];
	long		numFonts;
	long		loop;
	BRect		menuRect;
	BMenu*		theMenu;	

	chartWind = this;
	SetPulseRate(10000.0);
	fFontName = (char *)malloc(256);
	strcpy(fFontName, "Emily");
	fSymbolSet = (char *)malloc(256);
	strcpy(fSymbolSet, "Macintosh");
	fFontSize = 9;

	menuRect.Set(0,
				 0,
				 32767,
				 CHARTMENU);
	fMenuBar = new BMenuBar(menuRect, "MB");
	fMenuBar->SetBorder(B_BORDER_FRAME);


	theMenu = new BMenu("Font");
	theMenu->SetRadioMode(TRUE);
	fMenuBar->AddItem(theMenu);
	numFonts = count_fonts();
	for (loop = 0; loop < numFonts; loop++) {
		get_font_name(loop, (font_name*)&fontName);
		theMenu->AddItem(new BMenuItem(fontName, new BMessage(MENU_FONT)));
	}
	fMenuBar->FindItem(fFontName)->SetMarked(TRUE);	

	theMenu = new BMenu("Size");
	theMenu->SetRadioMode(TRUE);
	fMenuBar->AddItem(theMenu);
	theMenu->AddItem(new BMenuItem("9", new BMessage(MENU_SIZE)));
	theMenu->AddItem(new BMenuItem("10", new BMessage(MENU_SIZE)));
	theMenu->AddItem(new BMenuItem("11", new BMessage(MENU_SIZE)));
	theMenu->AddItem(new BMenuItem("12", new BMessage(MENU_SIZE)));
	theMenu->AddItem(new BMenuItem("13", new BMessage(MENU_SIZE)));
	theMenu->AddItem(new BMenuItem("14", new BMessage(MENU_SIZE)));
	fMenuBar->FindItem("9")->SetMarked(TRUE);	

	theMenu = new BMenu("Symbol Set");
	theMenu->SetRadioMode(TRUE);
	fMenuBar->AddItem(theMenu);
	numFonts = count_symbol_sets();
	for (loop = 0; loop < numFonts; loop++) {
		get_symbol_set_name(loop, (symbol_set_name*)&fontName);
		theMenu->AddItem(new BMenuItem(fontName, new BMessage(MENU_SYMBOL)));
	}
	fMenuBar->FindItem(fSymbolSet)->SetMarked(TRUE);
	Lock();
	AddChild(fMenuBar);
	Unlock();
}

//--------------------------------------------------------------------

TChartWindow::~TChartWindow()
{
	free ((char *)fFontName);
}

//--------------------------------------------------------------------

void TChartWindow::MessageReceived(BMessage* theMessage)
{
	char		keyboardID[64];
	BAlert		*myAlert;
	long		fontSize;
	BMenuItem	*item;
	ushort		ID;

	switch(theMessage->what) {
		case MENU_UNDO:
			break;
		case MENU_CUT:
			break;
		case MENU_COPY:
			break;
		case MENU_PASTE:
			break;
		case MENU_CLEAR:
			break;

		case MENU_KEYID:
			if (get_keyboard_id(&ID))
				sprintf(keyboardID,"No keyboard");
			else
				sprintf(keyboardID,"Keyboard ID: 0x%X", ID);
			be_app->SetCursor(B_HAND_CURSOR);
			myAlert = new BAlert("",keyboardID,"OK");
			myAlert->Go();
			break;

		case MENU_FONT:
			item = cast_as(theMessage->FindObject("source"), BMenuItem);
			ASSERT(item);
			if (strcmp(fFontName, item->Label())) {
				strcpy(fFontName, item->Label());
				tableView->ReDraw();
			}
			break;

		case MENU_SIZE:
			fontSize = theMessage->FindLong("index") + 9;
			if (fFontSize != fontSize) {
				fFontSize = fontSize;
				tableView->ReDraw();
			}
			break;

		case MENU_SYMBOL:
			item = cast_as(theMessage->FindObject("source"), BMenuItem);
			ASSERT(item);
			if (strcmp(fSymbolSet, item->Label())) {
				strcpy(fSymbolSet, item->Label());
				tableView->ReDraw();
			}
			break;
	}
}

//--------------------------------------------------------------------

void TChartWindow::SetMenuEnable(long theItem, bool theState)
{
	BMenuItem *item = fMenuBar->FindItem(theItem);
	if (!item)
		return;
	item->SetEnabled(theState);
}

//--------------------------------------------------------------------

void TChartWindow::SetMenuItemMark(long theItem, char theState)
{
	BMenuItem *item = fMenuBar->FindItem(theItem);
	if (!item)
		return;
	item->SetMarked(theState);
}

//--------------------------------------------------------------------

bool TChartWindow::QuitRequested()
{
	int		ref;
	BPoint	win_pos;
	BRect	r;

	r = Frame();
	win_pos = r.LeftTop();
	mkdir("/system/settings", 0777);
	if ((ref = creat("/system/settings/Chart_data", 0777)) >= 0) {
		write(ref, &win_pos, sizeof(BPoint));
		close(ref);
	}
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
}

//--------------------------------------------------------------------

void TChartWindow::WindowActivated(bool activFlag)
{
	if (!activFlag) {
		if (chartView) {
			be_app->SetCursor(B_HAND_CURSOR);
			chartView->fActive = FALSE;
		}
	}
	else
		chartView->fActive = TRUE;
}
