//--------------------------------------------------------------------
//	
//	FontChartView.h
//
//	Written by: Robert Polic
//	
//	Copyright 1997 Be, Inc. All Rights Reserved.
//	
//--------------------------------------------------------------------

#ifndef FONT_CHART_VIEW_H
#define FONT_CHART_VIEW_H

#ifndef FONT_CHART_WINDOW_H
#include "FontChartWindow.h"
#endif

#ifndef _VIEW_H
#ifndef _MESSAGE_H
#include <Message.h>
#endif
#ifndef _POINT_H
#include <Point.h>
#endif
#ifndef _RECT_H
#include <Rect.h>
#endif
#include <View.h>
#endif

#define CURSORSIZE		68	// cursor size in bytes
#define	WINDBORDER		3	// in pixels
#define	CELL_COLUMNS	16
#define	CELL_ROWS		16
#define	CELL_X_WIDTH	16	// in pixels
#define	CELL_Y_WIDTH	16	// in pixels
#define CELL_WIDTH		CELL_X_WIDTH * CELL_COLUMNS	// in pixels
#define	CELL_HEIGHT		CELL_Y_WIDTH * CELL_ROWS		// in pixels
#define	CHARTMENU		14					// in pixels


//====================================================================

class TChartView : public BView {

public:
bool			fClipFlag;
bool			fActive;
long			fHaveRed;
long			fLastKey;
long			fLastRaw;
uchar			fKeyStates[16];

				TChartView(BRect frame, char *name);
void			Copy();
void			DrawChar();
void			CheckStates(uchar * theMap);
virtual	void	AttachedToWindow();
virtual	void	Draw(BRect updateRect);
virtual void	KeyDown(ulong theKey);
virtual void	MessageReceived(BMessage *theMessage);
virtual void	MouseDown(BPoint thePoint);
virtual void	MouseMoved(BPoint thePoint, ulong code, BMessage *a_message);
virtual void	Pulse();
};

//====================================================================

class TTableView : public BView {

public:
				TTableView(BRect frame, char *name);
virtual	void	ReDraw();
virtual	void	Draw(BRect updateRect);
virtual void	KeyDown(ulong theKey);
virtual void	MouseDown(BPoint thePoint);
};
#endif
