//--------------------------------------------------------------------
//	
//	FontChartView.cpp
//
//	Written by: Robert Polic
//	
//	Copyright 1997 Be, Inc. All Rights Reserved.
//	
//--------------------------------------------------------------------

#include <OS.h>
#include <stdio.h>

#ifndef FONT_CHART_VIEW_H
#include "FontChartView.h"
#endif

extern		TChartWindow	*chartWind;


//====================================================================

TChartView	*chartView;
TChartView::TChartView(BRect rect, char *title)
	   :BView(rect, title, B_NOT_RESIZABLE, B_WILL_DRAW | B_PULSE_NEEDED)
{
	chartView = this;
}

//--------------------------------------------------------------------
TTableView	*tableView;
TTableView::TTableView(BRect rect, char *title)
	   :BView(rect, title, B_NOT_RESIZABLE, B_WILL_DRAW | B_PULSE_NEEDED)
{
	tableView = this;
}

//--------------------------------------------------------------------

void TChartView::AttachedToWindow()
{
	fClipFlag = FALSE;
	fActive = FALSE;
	fHaveRed = 0;
	SetFontName(chartWind->fFontName);
	SetFontSize(chartWind->fFontSize);
	SetSymbolSet(chartWind->fSymbolSet);
}

//--------------------------------------------------------------------

void TChartView::Draw(BRect where)
{
	bool	drawchar = FALSE;
	long	x;
	long	textLength;
	char	theText[256];
	BRect	theRect;

	SetFontName("Emily");
	SetFontSize(9);

	for (x = 0; x < CELL_COLUMNS; x++) {
		sprintf(theText, "%X", x);
		textLength = StringWidth(theText);
		MovePenTo(16 + (x * CELL_X_WIDTH) + ((CELL_X_WIDTH - textLength) / 2), 11);
		DrawString(theText);
		MovePenTo(3, 22 + (x * CELL_Y_WIDTH) + ((CELL_Y_WIDTH - 10) / 2));
		DrawString(theText);
	}

	MovePenTo(64, 15 + CELL_HEIGHT + 14);
	DrawString("Char:");
	textLength = StringWidth("Char: ") + 64;
	theRect.Set(textLength, 17 + CELL_HEIGHT, textLength + 36, 32 + CELL_HEIGHT);
	if (theRect.Intersects(where)) {
		drawchar = TRUE;
		StrokeRect(theRect);
	}
	theRect.top = theRect.bottom + 4;
	theRect.bottom += 20;
	if (theRect.Intersects(where)) {
		drawchar = TRUE;
		StrokeRect(theRect);
	}
	theRect.top = theRect.bottom + 4;
	theRect.bottom += 20;
	if (theRect.Intersects(where)) {
		drawchar = TRUE;
		StrokeRect(theRect);
	}
	if (drawchar)
		DrawChar();

	MovePenTo(158, 15 + CELL_HEIGHT + 14);
	DrawString("Key:");
	textLength = StringWidth("Key: ") + 158;
	theRect.Set(textLength, 17 + CELL_HEIGHT, textLength + 36, 32 + CELL_HEIGHT);
	if (theRect.Intersects(where))
		StrokeRect(theRect);

	theRect = Bounds();
	theRect.bottom -= 3;
	theRect.top = theRect.bottom - 16;
	theRect.left += 10;
	theRect.right -= 10;
	if (theRect.Intersects(where))
		StrokeRect(theRect);

	fKeyStates[0] |= 0x80;
	Pulse();
}

//--------------------------------------------------------------------

void TTableView::Draw(BRect where)
{
	long		x;
	long		y;
	BRect		theRect;
	long		textLength;
	char		theText[256];
	rgb_color	theColor;

	theColor.red = 0;
	theColor.green = 0;
	theColor.blue = 0;

	BeginLineArray(CELL_COLUMNS + CELL_ROWS + 2);
	for (x = 0; x <= CELL_COLUMNS; x += 1) {
		if ((x * CELL_X_WIDTH >= where.left) && (x * CELL_X_WIDTH <= where.right))
			AddLine(BPoint(x * CELL_X_WIDTH, 0),
					BPoint(x * CELL_X_WIDTH, CELL_HEIGHT), theColor);
	}
	for (y = 0; y <= CELL_ROWS; y += 1) {
		if ((y * CELL_Y_WIDTH >= where.top) && (y * CELL_Y_WIDTH <= where.bottom))
			AddLine(BPoint(0, y * CELL_Y_WIDTH),
					BPoint(CELL_WIDTH, y * CELL_Y_WIDTH), theColor);
	}
	EndLineArray();

	SetFontName(chartWind->fFontName);
	SetFontSize(chartWind->fFontSize);
	SetSymbolSet(chartWind->fSymbolSet);
	theText[1] = 0;
	theRect.Set(0, 0, CELL_X_WIDTH - 1, CELL_Y_WIDTH - 1);
	for (x = 0; x < CELL_COLUMNS; x += 1) {
		for (y = 0; y < CELL_COLUMNS; y += 1) {
			if (theRect.Intersects(where)) {
				theRect.InsetBy(1, 1);
				FillRect(theRect, B_SOLID_LOW);
				theRect.InsetBy(-1, -1);
				theText[0] = y * 16 + x;
				textLength = StringWidth(theText);
				MovePenTo(1 + (x * CELL_X_WIDTH) + ((CELL_X_WIDTH - textLength) / 2), y * CELL_Y_WIDTH + 13);
				DrawString(theText);
			}
			theRect.top += CELL_Y_WIDTH;
			theRect.bottom += CELL_Y_WIDTH;
		}
		theRect.top = 0;
		theRect.bottom = CELL_Y_WIDTH - 1;
		theRect.left += CELL_X_WIDTH;
		theRect.right += CELL_X_WIDTH;
	}

	x = chartView->fLastKey % CELL_COLUMNS;
	y = chartView->fLastKey / CELL_ROWS;
	theRect.Set(1 + (x * CELL_X_WIDTH), 1 + (y * CELL_Y_WIDTH),
				1 + (x * CELL_X_WIDTH) + CELL_X_WIDTH - 2,
				1 + (y * CELL_Y_WIDTH) + CELL_Y_WIDTH - 2);
	InvertRect(theRect);
}

//--------------------------------------------------------------------

void TTableView::ReDraw()
{
	Invalidate();
}

//--------------------------------------------------------------------

void TChartView::DrawChar()
{
	BRect	theRect;
	char	theText[256];
	long	textLength;

	textLength = StringWidth("Char: ") + 64;
	theRect.Set(textLength + 1, 18 + CELL_HEIGHT, textLength + 35, 31 + CELL_HEIGHT);
	FillRect(theRect, B_SOLID_LOW);
	sprintf(theText, "%c", fLastKey);
	textLength = StringWidth(theText) + 2;
	MovePenTo(theRect.right - textLength, theRect.bottom - 2);
	DrawString(theText);

	theRect.top = theRect.bottom + 6;
	theRect.bottom += 20;
	FillRect(theRect, B_SOLID_LOW);
	sprintf(theText, "0x%X", fLastKey);
	textLength = StringWidth(theText) + 2;
	MovePenTo(theRect.right - textLength, theRect.bottom - 2);
	DrawString(theText);

	theRect.top = theRect.bottom + 6;
	theRect.bottom += 20;
	FillRect(theRect, B_SOLID_LOW);
	sprintf(theText, "%d", fLastKey);
	textLength = StringWidth(theText) + 2;
	MovePenTo(theRect.right - textLength, theRect.bottom - 2);
	DrawString(theText);

	textLength = StringWidth("Key: ") + 158;
	theRect.Set(textLength + 1, 18 + CELL_HEIGHT, textLength + 35, 31 + CELL_HEIGHT);
	FillRect(theRect, B_SOLID_LOW);
	if (fLastRaw) {
		sprintf(theText, "%d", fLastRaw);
		textLength = StringWidth(theText) + 2;
		MovePenTo(theRect.right - textLength, theRect.bottom - 2);
		DrawString(theText);
	}
}

//--------------------------------------------------------------------

void TChartView::KeyDown(ulong theKey)
{
	long		x;
	long		y;
	BRect		theRect;
	BMessage*	theMessage;
	long		rawKey = 0;

	theMessage = Window()->CurrentMessage();
	rawKey = theMessage->FindLong("key", 0);
	if ((theKey != fLastKey) || (rawKey != fLastRaw)) {
		x = fLastKey % CELL_COLUMNS;
		y = fLastKey / CELL_ROWS;
		theRect.Set(16 + (x * CELL_X_WIDTH), 14 + (y * CELL_Y_WIDTH),
					16 + (x * CELL_X_WIDTH) + CELL_X_WIDTH - 2,
					14 + (y * CELL_Y_WIDTH) + CELL_Y_WIDTH - 2);
		InvertRect(theRect);

		fLastKey = theKey;
		fLastRaw = rawKey;
		x = fLastKey % CELL_COLUMNS;
		y = fLastKey / CELL_ROWS;
		theRect.Set(16 + (x * CELL_X_WIDTH), 14 + (y * CELL_Y_WIDTH),
					16 + (x * CELL_X_WIDTH) + CELL_X_WIDTH - 2,
					14 + (y * CELL_Y_WIDTH) + CELL_Y_WIDTH - 2);
		InvertRect(theRect);
		DrawChar();
	}
}


//--------------------------------------------------------------------

void TTableView::KeyDown(ulong theKey)
{
	chartView->KeyDown(theKey);
}

//--------------------------------------------------------------------

void TChartView::MessageReceived(BMessage *theMessage)
{
}

//--------------------------------------------------------------------

void TChartView::MouseDown(BPoint thePoint)
{
	BRect		theCell;
	long		textLength;
	BMessage*	msg;
	char		theText[256];
	long		loop;
	BPoint		where;
	ulong		buttons;

	GetMouse(&where, &buttons);
	if ((!chartView->fActive) && (buttons & 1)) {
		chartWind->Activate(TRUE);
		return;
	}

	textLength = StringWidth("Char: ") + 64;
	theCell.Set(textLength, 17 + CELL_HEIGHT, textLength + 36, 32 + CELL_HEIGHT);
	if (theCell.Contains(thePoint)) {
		msg = new BMessage(B_KEY_DOWN);
		msg->AddLong("char", fLastKey);
		msg->AddLong("modifiers", modifiers());
		DragMessage(msg, theCell);
	}
	theCell.top = theCell.bottom + 4;
	theCell.bottom += 20;
	if (theCell.Contains(thePoint)) {
		sprintf(theText, "0x%X", fLastKey);
		msg = new BMessage(B_SIMPLE_DATA);
		msg->AddLong("modifiers", modifiers());
		loop = 0;
		while (theText[loop]) {
			loop++;
		}
		msg->AddData("text", B_ASCII_TYPE, theText, loop);
		DragMessage(msg, theCell);
	}
	theCell.top = theCell.bottom + 4;
	theCell.bottom += 20;
	if (theCell.Contains(thePoint)) {
		sprintf(theText, "%d", fLastKey);
		msg = new BMessage(B_SIMPLE_DATA);
		msg->AddLong("modifiers", modifiers());
		loop = 0;
		while (theText[loop]) {
			loop++;
		}
		msg->AddData("text", B_ASCII_TYPE, theText, loop);
		DragMessage(msg, theCell);
	}
}

//--------------------------------------------------------------------

void TTableView::MouseDown(BPoint thePoint)
{
	BRect		theMatrix;
	BRect		theCell;
	BPoint		where;
	BPoint		start;
	ulong		buttons;
	ulong		buttonState;
	long		lastKey;
	long		x;
	long		lastx;
	long		y;
	long		lasty;
	bool		mouseMoved = FALSE;
	BMessage*	msg;

	theMatrix = Frame();
	theMatrix.OffsetTo(BPoint(0, 0));
	theMatrix.right -= 1;
	theMatrix.bottom -= 1;
	lastKey = chartView->fLastKey;
	lastx = lastKey % CELL_COLUMNS;
	lasty = lastKey / CELL_ROWS;

	GetMouse(&start, &buttons);
	if (!chartView->fActive) {
		do {
			GetMouse(&where, &buttonState);
			if ((where.x != start.x) || (where.y != start.y))
				mouseMoved = TRUE;
		} while ((!mouseMoved) & (buttonState != 0));
	}
	else {
		buttonState = buttons;
		where.x = start.x;
		where.y = start.y;
	}

	if ((!chartView->fActive) && (!mouseMoved)) {
		chartWind->Activate(TRUE);
		return;
	}

	if (buttonState & 6) {
		x = where.x / CELL_X_WIDTH;
		y = where.y / CELL_Y_WIDTH;
		theCell.Set(x * CELL_X_WIDTH, y * CELL_Y_WIDTH,
					x * CELL_X_WIDTH + CELL_X_WIDTH,
					y * CELL_Y_WIDTH + CELL_Y_WIDTH);
		msg = new BMessage(B_KEY_DOWN);
		msg->AddLong("char", y * CELL_COLUMNS + x);
		msg->AddLong("modifiers", modifiers());
		msg->AddLong("thread", (long)find_thread(NULL));
		DragMessage(msg, theCell);
	}
	else do {	
		chartView->fLastRaw = 0;
		GetMouse(&where, &buttons);
		if (theMatrix.Contains(where)) {
			x = where.x / CELL_X_WIDTH;
			y = where.y / CELL_Y_WIDTH;
			if ((x != lastx) || (y != lasty)) {
				theCell.Set(1 + (x * CELL_X_WIDTH), 1 + (y * CELL_Y_WIDTH),
							1 + (x * CELL_X_WIDTH) + CELL_X_WIDTH - 2,
							1 + (y * CELL_Y_WIDTH) + CELL_Y_WIDTH - 2);
				InvertRect(theCell);
				theCell.Set(1 + (lastx * CELL_X_WIDTH), 1 + (lasty * CELL_Y_WIDTH),
							1 + (lastx * CELL_X_WIDTH) + CELL_X_WIDTH - 2,
							1 + (lasty * CELL_Y_WIDTH) + CELL_Y_WIDTH - 2);
				InvertRect(theCell);
				chartView->fLastKey = y * CELL_COLUMNS + x;
				lastx = x;
				lasty = y;
				chartView->DrawChar();
			}
		}
		else {
			if (lastKey != chartView->fLastKey) {
				x = chartView->fLastKey % CELL_COLUMNS;
				y = chartView->fLastKey / CELL_ROWS;
				theCell.Set(1 + (x * CELL_X_WIDTH), 1 + (y * CELL_Y_WIDTH),
							1 + (x * CELL_X_WIDTH) + CELL_X_WIDTH - 2,
							1 + (y * CELL_Y_WIDTH) + CELL_Y_WIDTH - 2);
				InvertRect(theCell);

				chartView->fLastKey = lastKey;
				lastx = chartView->fLastKey % CELL_COLUMNS;
				lasty = chartView->fLastKey / CELL_ROWS;
				theCell.Set(1 + (lastx * CELL_X_WIDTH), 1 + (lasty * CELL_Y_WIDTH),
							1 + (lastx * CELL_X_WIDTH) + CELL_X_WIDTH - 2,
							1 + (lasty * CELL_Y_WIDTH) + CELL_Y_WIDTH - 2);
				InvertRect(theCell);
				chartView->DrawChar();
			}
		}	
	snooze(50000.0);
	} while(buttons);
}

//--------------------------------------------------------------------

void TChartView::MouseMoved(BPoint thePoint, ulong code, BMessage *a_message)
{
}

//--------------------------------------------------------------------

void TChartView::Pulse()
{
	key_info	theKeys;

	GetKeys(&theKeys, FALSE);
	CheckStates((uchar *)&theKeys.key_states);
}

//--------------------------------------------------------------------

void TChartView::CheckStates(uchar * keyStates)
{
	long		loop;
	long		changed = 0;
	char		stateString[33];
	BRect		theRect;
	long		length;

	if (fKeyStates[0] & 0x80) {
		fKeyStates[0] &= 0x7f;
		changed = 0x10000;
	}

	for (loop = 0; loop < 16; loop++)
		if (fKeyStates[loop] != keyStates[loop]) {
			fKeyStates[loop] = keyStates[loop];
			changed |= 1 << loop;
		}

	if ((changed) || (fHaveRed)) {
		theRect = Bounds();
		theRect.bottom -= 4;
		theRect.top = theRect.bottom - 14;
		theRect.left += 11;
		theRect.right -= 11;
		
		if (changed) {
			fHaveRed = 3;
			FillRect(theRect, B_SOLID_LOW);
		}
		else {
			fHaveRed -= 1;
			if (fHaveRed)
				return;
		}

		stateString[32] = 0;
		for (loop = 0; loop < 16; loop++) {
			sprintf(&stateString[loop * 2], "%x", keyStates[loop]);
			if (!stateString[loop * 2 + 1]) {
				stateString[loop * 2 + 1] = stateString[loop * 2];
				stateString[loop * 2] = '0';
			}
		}
		length = StringWidth(stateString);
		length = (((theRect.right - theRect.left) - length) / 2) + theRect.left;
		MovePenTo(length, theRect.bottom - 2);
		if (!changed)
			DrawString(stateString);
		else {
			for (loop = 0; loop < 16; loop++) {
				if (changed & 1)
					SetHighColor(255, 0, 0);
				DrawString(&stateString[loop * 2], 2);
				if (changed & 1)
					SetHighColor(0, 0, 0);
				changed = changed >> 1;
			}
		}
	}
}

//--------------------------------------------------------------------

void TChartView::Copy()
{
}
