//--------------------------------------------------------------------
//	
//	FontChart.cpp
//
//	Written by: Robert Polic
//	
//	Copyright 1997 Be, Inc. All Rights Reserved.
//	
//--------------------------------------------------------------------

#ifndef FONT_CHART_H
#include "FontChart.h"
#endif
#include <fcntl.h>
#include <unistd.h>

extern	TChartView	*chartView;
extern	TTableView	*tableView;


//====================================================================

int main(long argc, char* argv[])
{	
	TChartApplication	*myApplication;

	myApplication = new TChartApplication();
	myApplication->Run();	
	delete myApplication;
	
	return(1);
}

//--------------------------------------------------------------------

TChartApplication::TChartApplication()
		  :BApplication('KEYS')
{
	int				ref;
	float			height;
	BPoint			win_pos;
	BRect			chartWindowRect;
	BRect			chartViewRect;
	screen_info		sInfo;
	TChartWindow	*myChartWindow;
	TChartView		*myChartView;
	TTableView		*myTableView;
	
	chartView = NIL;
	tableView = NIL;
	chartWindowRect.Set(BROWSERWIND,
					    TITLEBARHEIGHT,
					    BROWSERWIND + CELL_WIDTH + (WINDBORDER * 2) + 12,
					    TITLEBARHEIGHT + CELL_HEIGHT + (WINDBORDER * 2) + CHARTMENU + (4 * 13) + 17 + 20 + 1);
	get_screen_info(0, &sInfo);
	if ((ref = open("/system/settings/Chart_data", 0)) >= 0) {
		read(ref, &win_pos, sizeof(BPoint));
		close(ref);
		if (sInfo.frame.Contains(win_pos))
			chartWindowRect.OffsetTo(win_pos);
	}
	myChartWindow = new TChartWindow(chartWindowRect, "Font Chart");
	myChartWindow->Lock();
	height = myChartWindow->fMenuBar->Bounds().bottom + 1;
	myChartWindow->ResizeBy(0, height - CHARTMENU);
	myChartWindow->Unlock();

	chartViewRect.Set(15,
					 13 + height,
					 15 + CELL_WIDTH,
					 height + 13 + CELL_HEIGHT);
	myTableView = new TTableView(chartViewRect, "Table");

	chartViewRect.Set(0,
					 height,
					 CELL_WIDTH + (WINDBORDER * 2) + 13,
					 CELL_HEIGHT + (WINDBORDER * 2) + height + (4 * 13) + 17 + 20);
	myChartView = new TChartView(chartViewRect, "ChartView");

	myChartWindow->Lock();
	myChartWindow->AddChild(myTableView);
	myChartWindow->AddChild(myChartView);
	myChartWindow->Unlock();
	myChartWindow->Show();

	myChartWindow->Activate(TRUE);
	myTableView->Window()->Lock();
	myTableView->MakeFocus();
	myTableView->Window()->Unlock();
}

//--------------------------------------------------------------------

void TChartApplication::AboutRequested()
{
	BAlert		*myAlert;

	myAlert = new BAlert("","...by Robert Polic","Big Deal");
	myAlert->Go();
}
