/* DDWindow.h */
#include <Window.h>
#include "FilterView.h"

class DDWindow : public BWindow
{
 public:
 	DDWindow();
  	void MessageReceived(BMessage* msg);
	bool QuitRequested();
	
	inline int32 Mass()  const;
	inline int32 Drag()  const;
	inline int32 Width() const;
	inline int32 Sleep() const;
	inline rgb_color Color() const; 
	
 private:
 	FilterView* fv;

};

/* inline functions */
int32 DDWindow::Mass()  const { return fv->Mass(); }
int32 DDWindow::Drag()  const { return fv->Drag(); }
int32 DDWindow::Width() const { return fv->Width(); }
int32 DDWindow::Sleep() const { return fv->Sleep(); }
rgb_color DDWindow::Color() const { return fv->HighColor(); }