//--------------------------------------------------------------------
//	
//	Slider.cpp
//
//	Written by: Robert Polic
//	
//	Copyright 1996 Be, Inc. All Rights Reserved.
//	
//--------------------------------------------------------------------

#ifndef SLIDER_H
#include "Slider.h"
#endif
#ifndef SLIDER_BITS_H
#include "SliderBits.h"
#endif



//====================================================================

int main()
{	
	TSliderApp	*app;

	app = new TSliderApp();
	app->Run();

	delete app;
	return B_NO_ERROR;
}

//--------------------------------------------------------------------

TSliderApp::TSliderApp()
		   :BApplication('SLDR')
{
	BRect			r;
	TSliderWindow	*slider_window;

	r.Set(BROWSER_WIND, TITLE_BAR_HEIGHT,
		  BROWSER_WIND + WIND_WIDTH, TITLE_BAR_HEIGHT + WIND_HEIGHT);
	slider_window = new TSliderWindow(r, "Slider");
	slider_window->Show();
}

//--------------------------------------------------------------------

void TSliderApp::AboutRequested()
{
	char	about[32] = "...by Robert Polic";
	BAlert	*myAlert;

	myAlert = new BAlert("",about,"Big Deal");
	myAlert->Go();
}



//====================================================================

TSliderWindow::TSliderWindow(BRect rect, char *title)
	          :BWindow(rect, title, B_TITLED_WINDOW, B_NOT_RESIZABLE |
													 B_NOT_ZOOMABLE)
{
	BRect			r;
	TView			*view;
	TSliderView		*slider_view;

	// create a view that fills the whole window
	r = rect;
	r.OffsetTo(0.0, 0.0);
	view = new TView(r, "View");

	// center the slider view in the window
	r.left = (r.Width() - SLIDER_BACK_WIDTH) / 2;
	r.right = r.left + SLIDER_BACK_WIDTH;
	r.top = (r.Height() - SLIDER_BACK_HEIGHT) / 2;
	r.bottom = r.top + SLIDER_BACK_HEIGHT;
	slider_view = new TSliderView(r, "SliderView");

	// add views (do it in this order so slider gets mouse first)
	AddChild(slider_view);
	AddChild(view);
}

//--------------------------------------------------------------------

bool TSliderWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return TRUE;
}



//====================================================================

TView::TView(BRect rect, char *title)
	  :BView(rect, title, B_FOLLOW_ALL, B_WILL_DRAW)
{
}

//--------------------------------------------------------------------

void TView::AttachedToWindow()
{
	rgb_color	c;

	c.red = c.green = c.blue = BACK_COLOR;
	SetViewColor(c);
}



//====================================================================

TSliderView::TSliderView(BRect rect, char *title)
			:BView(rect, title, B_FOLLOW_ALL, B_WILL_DRAW)
{
	BRect	r;

	fValue = 1.00;

	// load in our canned slider knob bitmap
	r.Set(0, 0, ((KNOB_WIDTH + 7) & 0xfff8) - 1, KNOB_HEIGHT);
	fKnob = new BBitmap(r, B_COLOR_8_BIT);
	fKnob->SetBits((char*)knob, fKnob->BitsLength(), 0, B_COLOR_8_BIT);

	// create our offscreen drawing environment
	r = Bounds();
	fSlider = new BBitmap(r, B_COLOR_8_BIT, TRUE);
	fSlider->AddChild(fOffView = new BView(r, "", B_FOLLOW_ALL, B_WILL_DRAW));
}

//--------------------------------------------------------------------

TSliderView::~TSliderView()
{
	delete fSlider;
	delete fKnob;
}

//--------------------------------------------------------------------

void TSliderView::Draw(BRect where)
{
	DrawSlider();
}

//--------------------------------------------------------------------

void TSliderView::MouseDown(BPoint thePoint)
{
	ulong	buttons;
	float	old_value;
	float	temp;
	BPoint	where;
	BRect	r;

	r.left = ((SLIDER_BACK_WIDTH - KNOB_WIDTH - 4.0) * fValue) + 2.0;
	r.top = 0.0;
	r.right = r.left + KNOB_WIDTH;
	r.bottom = KNOB_HEIGHT;

	if (!r.Contains(thePoint)) {
		temp = (thePoint.x / (SLIDER_BACK_WIDTH - KNOB_WIDTH - 4.0)) -
							 ((KNOB_WIDTH / 2.0) / SLIDER_BACK_WIDTH);
		if (temp < 0.00)
			temp = 0.00;
		if (temp > 1.00)
			temp = 1.00;
		if (temp != fValue)
			SetValue(temp);
	}
	old_value = fValue;

	do {
		GetMouse(&where, &buttons);
		temp = old_value + ((where.x - thePoint.x) /
							(SLIDER_BACK_WIDTH - KNOB_WIDTH - 2.0));
		if (temp < 0.00)
			temp = 0.00;
		if (temp > 1.00)
			temp = 1.00;
		if (temp != fValue) {
			SetValue(temp);
		}
		snooze(500.0);	// be a good citizen
	} while (buttons);
}

//--------------------------------------------------------------------

void TSliderView::DrawSlider()
{
	BRect	sr;
	BRect	dr;

	fSlider->Lock();
	sr = fOffView->Bounds();

	// slider background
	fOffView->SetHighColor(BACK_COLOR, BACK_COLOR, BACK_COLOR);
	fOffView->FillRect(sr);
	fOffView->SetHighColor(176, 176, 176);
	fOffView->StrokeLine(BPoint(0, 5), BPoint(0, 5));
	fOffView->StrokeLine(BPoint(0, 10), BPoint(0, 10));
	fOffView->StrokeLine(BPoint(SLIDER_BACK_WIDTH, 5), BPoint(SLIDER_BACK_WIDTH, 5));
	fOffView->SetHighColor(255, 255, 255);
	fOffView->StrokeLine(BPoint(1, 10), BPoint(SLIDER_BACK_WIDTH, 10));
	fOffView->StrokeLine(BPoint(SLIDER_BACK_WIDTH, 9), BPoint(SLIDER_BACK_WIDTH, 6));
	fOffView->SetHighColor(144, 144, 144);
	fOffView->StrokeLine(BPoint(0, 6), BPoint (0, 9));
	fOffView->StrokeLine(BPoint(1, 5), BPoint(SLIDER_BACK_WIDTH - 1, 5));
	fOffView->SetHighColor(0, 0, 0);
	fOffView->StrokeLine(BPoint(1, 6), BPoint(SLIDER_BACK_WIDTH - 1, 6));
	fOffView->StrokeLine(BPoint(1, 7), BPoint(SLIDER_BACK_WIDTH - 1, 7));
	fOffView->StrokeLine(BPoint(1, 8), BPoint(1, 9));
	fOffView->StrokeLine(BPoint(SLIDER_BACK_WIDTH - 1, 8), BPoint(SLIDER_BACK_WIDTH - 1, 9));
	fOffView->SetHighColor(64, 64, 64);
	sr.Set(2, 8, SLIDER_BACK_WIDTH - 2, 9);
	fOffView->FillRect(sr);

	// knob
	sr.Set(0, 0, KNOB_WIDTH, KNOB_HEIGHT);
	dr.left = ((SLIDER_BACK_WIDTH - KNOB_WIDTH - 4.0) * fValue) + 2.0;
	dr.top = 0;
	dr.right = dr.left + KNOB_WIDTH;
	dr.bottom = dr.top + KNOB_HEIGHT;
	fOffView->DrawBitmap(fKnob, sr, dr);
	fOffView->SetHighColor(0, 0, 0);

	fOffView->Sync();	// make sure offscreen drawing completes

	// copy offscreen to screen
	DrawBitmap(fSlider, BPoint(0, 0));
	fSlider->Unlock();
}

//--------------------------------------------------------------------

void TSliderView::SetValue(float value)
{
	fValue = value;
	DrawSlider();
}

//--------------------------------------------------------------------

float TSliderView::Value()
{
	return (fValue);
}
