#include <Application.h>
#include <Window.h>
#include <View.h>
#include <StringView.h>
#include <File.h>
#include <Resources.h>
#include <stdio.h>
#include <string.h>

/////////////////
// declarations

class AWindow:public BWindow {
public:
	AWindow(BMessage*);
private:
	void MessageReceived(BMessage*);
	bool QuitRequested();

	void DumpArchive();
	void CloneWindow();
	void NewColor(rgb_color);

	int32 numclicks;
};

class AApplication:public BApplication {
public:
	AApplication();
private:
	void ReadyToRun();
};

void PrintMessageToStream(BMessage*,uint32=0);
BMessage* ReadMessageFromResource(int32);

/////////////////////
// global variables

int32 numwindows=0;

//////////////////
// class AWindow

AWindow::AWindow(BMessage* m):BWindow(m) {
	atomic_add(&numwindows,1);
	numclicks=m->FindInt32("clicks");
//	BView* v=FindView("clone");
//	if (v!=NULL) {
//		v->SetViewColor(216,216,216);
//		v->SetLowColor(216,216,216);
//	}
	Show();
}

void AWindow::MessageReceived(BMessage* m) {
	switch(m->what) {
		case 'colr' : {
			rgb_color col;
			const void* the_color;
			ssize_t the_size;
			if (m->FindData("color",B_RGB_COLOR_TYPE,&the_color,&the_size)==B_OK) {
				memcpy(&col,the_color,the_size);
				NewColor(col);
			}
			break;
		}
		case 'dump' : {
			DumpArchive();
			break;
		}
		case 'clon' : {
			CloneWindow();
			break;
		}
		default:
			BWindow::MessageReceived(m);
			break;
	}
}

bool AWindow::QuitRequested() {
// cannot use BApplication::CountWindows() because of a race condition
	if (atomic_add(&numwindows,-1)==1) be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}

void AWindow::NewColor(rgb_color col) {
	BView* v;
	BStringView* sv;
	char text[20];
	numclicks++;
	v=FindView("colorview");
	if (v!=NULL) {
		v->SetViewColor(col);
		v->Invalidate();
	}
	sv=dynamic_cast<BStringView*>(FindView("stringview"));
	if (sv!=NULL) {
		sprintf(text,"%ld click%s",numclicks,(numclicks==1)?"":"s");
		sv->SetText(text);
	}
}

void AWindow::DumpArchive() {
	BMessage msg;
	Archive(&msg);
	msg.AddInt32("clicks",numclicks);
	PrintMessageToStream(&msg);
}

void AWindow::CloneWindow() {
	BMessage msg;
	Archive(&msg);
	msg.AddInt32("clicks",numclicks);
	BRect frame=msg.FindRect("_frame"); // move the window so that
	frame.OffsetBy(15,15);				// it doesn't appear on top of
	msg.ReplaceRect("_frame",frame);	// the original one.
	new AWindow(&msg);
}

///////////////////////
// class AApplication

AApplication::AApplication():BApplication("application/x-vnd.Be-sample-jbq2-2") {
	Run();
}

void AApplication::ReadyToRun() {
	BMessage* msg=ReadMessageFromResource(0);
	if (msg) {
		new AWindow(msg);
		delete msg;
	} else {
		PostMessage(B_QUIT_REQUESTED);
	}
}

/////////////////////
// global functions

void PrintMessageToStream(BMessage* m,uint32 reclevel) {
	if (reclevel) printf("recursing sub-view [%ld]\n",reclevel);
	m->PrintToStream();
	BMessage msg;
	if (m->FindMessage("_msg",0,&msg)==B_OK) {
		printf("model BMessage\n");
		msg.PrintToStream();
	}
	for (int nmess=0;m->FindMessage("_views",nmess,&msg)==B_OK;nmess++) {
		PrintMessageToStream(&msg,reclevel+1);
	}
	if (reclevel) printf("end recursion [%ld]\n",reclevel);
}

BMessage* ReadMessageFromResource(int32 id) {
	app_info ai;
	BFile f;
	BResources r;
	size_t res_size;
	const void* res_addr;
	BMessage* msg=new BMessage;
	if ((be_app->GetAppInfo(&ai)!=B_OK)
	 ||(f.SetTo(&ai.ref,B_READ_ONLY)!=B_OK)
	 ||(r.SetTo(&f)!=B_OK)
	 ||((res_addr=r.LoadResource(B_MESSAGE_TYPE,id,&res_size))==NULL)
	 ||(msg->Unflatten((const char*)res_addr)!=B_OK)) {
		delete msg;
		return NULL;
	}
	return msg;
}

main() {
	delete new AApplication;
}
