#ifndef _BORDER_PRINT_H_
#define _BORDER_PRINT_H_

#include <PrintJob.h>
#include <Rect.h>
#include <Window.h>

class BorderPrint : public BPrintJob
{
 public:
						BorderPrint(const char *);
	virtual				~BorderPrint();
	
	void				SpoolPage();
	
	void				DrawView(BView*, BRect, BPoint);					

	BRect				PrintableRect();
						
 protected: 

	class BorderView : public BView
	{
	 public:
								BorderView(BRect,const char*);
								~BorderView();
		void					Draw(BRect);
		void					PageNum(int32);

		BRect					ApplicationUsableArea();
		BPoint					Offset();
		
	 protected:
		BRect					fPrintableRect;
		char					*fTitle;
		char					*fTime;
		int32					fPageNumber;
	};

	void					CreateBorderView();

	bool					fIsNewPage;
	BRect					fPrintableRect;
	BorderView				*fBorderView;
	char					*fTitle;
	int32					fNumSpooledPages;
	BBitmap					*winBitmap;
};


#endif