/*
** Copyright (c) 1997, 3Dfx Interactive, Inc.
** All Rights Reserved.
**
** This is UNPUBLISHED PROPRIETARY SOURCE CODE of 3Dfx Interactive, Inc.;
** the contents of this file may not be disclosed to third parties, copied or
** duplicated in any form, in whole or in part, without the prior written
** permission of 3Dfx Interactive, Inc.
**
** RESTRICTED RIGHTS LEGEND:
** Use, duplication or disclosure by the Government is subject to restrictions
** as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
** and Computer Software clause at DFARS 252.227-7013, and/or in similar or
** successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
** rights reserved under the Copyright Laws of the United States.
**
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#if !defined(macintosh) && !defined(__BEOS__)
#include <conio.h>
#endif
#include <assert.h>

#include <glide.h>
#include "tlib.h"


GrHwConfiguration hwconfig;
static char version[80];

static const char name[]    = "test12";
static const char purpose[] = "lfb, renderbuffer, yorigin test";
static const char usage[]   = "-n <frames> -r <res>";

static int rRandom(int s, int e);
static unsigned int iRandom (unsigned int maxr);

void main( int argc, char **argv) {
    char match; 
    char **remArgs;
    int  rv;

    GrScreenResolution_t resolution = GR_RESOLUTION_640x480;
    float                scrWidth   = 640.0f;
    float                scrHeight  = 480.0f;
    int frames                      = -1;

    static unsigned short colorBuf[64][64];
    static unsigned short grabBuf[64][64];
    
    int x,y;
#ifdef __BEOS__
	InitBe();
#endif

    /* Process Command Line Arguments */
    while( rv = tlGetOpt( argc, argv, "nr", &match, &remArgs ) ) {
        if ( rv == -1 ) {
            printf( "Unrecognized command line argument\n" );
            printf( "%s %s\n", name, usage );
            printf( "Available resolutions:\n%s\n",
                    tlGetResolutionList() );
            return;
        }
        switch( match ) {
        case 'n':
            frames = atoi( remArgs[0] );
            break;
        case 'r':
            resolution = tlGetResolutionConstant( remArgs[0], 
                                                  &scrWidth, 
                                                  &scrHeight );
            break;
        }
    }

    tlSetScreen( scrWidth, scrHeight );

    grGlideGetVersion( version );

    printf( "%s:\n%s\n", name, purpose );
    printf( "%s\n", version );
    printf( "Resolution: %s\n", tlGetResolutionString( resolution ) );
    if ( frames == -1 ) {
        #if defined(macintosh)
    	printf( "Click the mouse to begin test.\n");
    	while (!Button());
    	#else
        printf( "Press A Key To Begin Test.\n" );
		#if defined (__BEOS__)
		tlGetCH();
		#else        
        getch();
    	#endif
        #endif
    }
    
    /* Initialize Glide */
    grGlideInit();
    assert( grSstQueryHardware( &hwconfig ) );
    grSstSelect( 0 );
    assert( grSstWinOpen( NULL,resolution,
                       GR_REFRESH_60Hz,
                       GR_COLORFORMAT_ABGR,
                       GR_ORIGIN_UPPER_LEFT,
                       GR_SMOOTHING_ENABLE,
                       2 ) );
    
    tlConSet( tlScaleX( 0.0f ), tlScaleY( 0.0f ),
              tlScaleX( 1.0f ), tlScaleY( 0.5f ),
              60, 15, 0xffffff );

    /* Set up Render State - disable dithering - rgb triangles */
    grDitherMode( GR_DITHER_DISABLE );
    grColorCombine( GR_COMBINE_FUNCTION_LOCAL,
                    GR_COMBINE_FACTOR_NONE,
                    GR_COMBINE_LOCAL_ITERATED,
                    GR_COMBINE_OTHER_NONE,
                    FXFALSE );


    /* Create Source Bitmap to be copied to framebuffer */
    for( y = 0; y < 64; y++ ) {
        for( x = 0; x < 64; x++ ) {
            FxU8 red = x << 2;
            FxU8 grn = y << 2;
            FxU8 blu = ( x + y )<<1;
            colorBuf[y][x] =  (red & 0xF8) << 8;
            colorBuf[y][x] |= (grn & 0xFC) << 3;
            colorBuf[y][x] |= (blu & 0xF8) >> 3;
        }
    }
    
    /* LFB an image to the back buffer, swap it forward,
       set the render buffer to the front buffer and 
       partially occlude the image with a triangle,
       pause
       
       point the render buffer to the back buffer,
       lfb the image to the back buffer, render
       a triangle over half of the image, swap,
       pause 
       
       */

    tlConOutput( "Press any key to quit\n" );
    while( frames-- ) {
        GrLfbInfo_t info;
        int startX, startY;
        GrVertex a, b, c;
        int origin;
        
        /* prepare info structure */
        info.size = sizeof( GrLfbInfo_t );
        
        /* randomly flip the yorigin */
        origin = rRandom( 0, 1 );
        grSstOrigin( origin );
        
        /* lock back buffer */
        if ( grLfbLock( GR_LFB_WRITE_ONLY,
                        GR_BUFFER_BACKBUFFER,
                        GR_LFBWRITEMODE_565,
                        GR_ORIGIN_UPPER_LEFT,
                        FXFALSE,
                        &info )==FXFALSE) {
            tlConOutput( "Error, failed to take write lock\n" );
            break;
        } 
        
        /* generate random start position */
        startX = (int)rRandom( 64, (int)scrWidth - 65 );
        startY = (int)rRandom( 64, (int)scrHeight - 65 );
        
        /* render image to back buffer */
        for( y = 0; y < 64; y++ ) {
            for( x = 0; x < 64; x++ ) {
                FxU16 *pixel = 
                    (FxU16*)(((char*)info.lfbPtr) + 
                             (y+startY)*info.strideInBytes+
                             (x+startX)*2);
                *pixel = colorBuf[y][x];
            }
        }
        
        grLfbUnlock( GR_LFB_WRITE_ONLY, GR_BUFFER_BACKBUFFER );

        /* swap to front buffer */
        tlConRender();
        grBufferSwap( 2 );
        
       /* Draw white triangle over lfb rect
          a
          |\
          | \
          b--c
          */
        grRenderBuffer( GR_BUFFER_FRONTBUFFER );
        a.r = a.g = a.b = 255.0f;
        b = c = a;
        
        b.x = a.x = (float)startX;
        c.x = (float)(startX+64);
        
        if ( origin ) {
            a.y = (scrHeight-1.0f) - (float)startY;
            b.y = c.y = (scrHeight-1.0f) - (float)(startY+64);
        } else {
            a.y = (float)startY;
            b.y = c.y = (float)(startY+64);
        }
        
        grDrawTriangle( &a, &b, &c );
        

        tlSleep( 1 );

        if ( grLfbLock( GR_LFB_WRITE_ONLY, GR_BUFFER_BACKBUFFER,
                        GR_LFBWRITEMODE_565, GR_ORIGIN_UPPER_LEFT,
                        FXFALSE, &info ) == FXFALSE ) {
            tlConOutput( "Error, Failed to lock back buffer\n" );
            break;
        }
             
        /* generate random start position */
        startX = (int)rRandom( 64, (int)scrWidth - 65 );
        startY = (int)rRandom( 64, (int)scrHeight - 65 );
        
        /* render image to back buffer */
        for( y = 0; y < 64; y++ ) {
            for( x = 0; x < 64; x++ ) {
                FxU16 *pixel = 
                    (FxU16*)(((char*)info.lfbPtr) + 
                             (y+startY)*info.strideInBytes+
                             (x+startX)*2);
                *pixel = colorBuf[y][x];
            }
        }
        
        /* unlock buffer */
        grLfbUnlock( GR_LFB_WRITE_ONLY, GR_BUFFER_BACKBUFFER );
        
        /* Draw white triangle over lfb rect
           a
           |\
           | \
           b--c
           */
        grRenderBuffer( GR_BUFFER_BACKBUFFER );
        a.r = a.g = a.b = 255.0f;
        b = c = a;
        
        b.x = a.x = (float)startX;
        c.x = (float)(startX+64);
        
        if ( origin ) {
            a.y = (scrHeight-1.0f) - (float)startY;
         b.y = c.y = (scrHeight-1.0f) - (float)(startY+64);
        } else {
            a.y = (float)startY;
            b.y = c.y = (float)(startY+64);
        }
        
        grDrawTriangle( &a, &b, &c );

        tlConRender();
        grBufferSwap( 2 );
        
        tlSleep( 1 );
        
        #if defined(macintosh)
		if (Button()) frames = 0;
#else
        while( tlKbHit() ) {
            switch( tlGetCH() ) {
            default:
                frames = 0;
                break;
            }
        }
#endif
    }
    
    grGlideShutdown();
    return;
}

static unsigned long randx = 1;

static unsigned int iRandom (unsigned int maxr)
{
    unsigned int n,retval;

    if (maxr > 0xFFFFFFF) {
        do {
            retval = iRandom(0xFFFFFFF);
            retval |= iRandom(maxr>>28)<<28;
        } while (retval > maxr);
        return retval;
    }
    for (n=1; n<32; n++)
        if (((unsigned)1 << n) > maxr) break;
    do {
        randx = randx*1103515245 + 12345;
        retval = (randx & 0x7fffffff) >> (31-n);
    } while (retval > maxr);
    return retval;
}

static int rRandom(int s, int e)
{
    return s + iRandom(e-s);
}



