DRIVER_DIR=/boot/home/config/add-ons/kernel/drivers
LIB_DIR=/boot/home/config/lib
THDFX_DRIVER=thdfx
GLIDE_LIB=lib3DfxGlide2X.so
DRIVER_SRC_DIR=./driver
LIB_SRC_DIR=./lib


echo
echo
echo '*********************** 3DFX GLIDE LIBRARY 2.X INSTALL ***********************'
echo
echo 'This script enables you to use the glide library with a 3dfx card on the BeOS.'
echo
echo 'It will install the following:'
echo
echo "$DRIVER_DIR/$THDFX_DRIVER (3dfx driver)"
echo "$LIB_DIR/$GLIDE_LIB (glide library)"

echo 'Do you wish to continue (y/n)'
read RESPONSE

if [ "$RESPONSE" = 'y' ] || [ $RESPONSE = 'Y' ]; 
then
	echo "Installing 3dfx driver in $DRIVER_DIR" 
	mkdir -p $DRIVER_DIR
	cp $DRIVER_SRC_DIR/$THDFX_DRIVER $DRIVER_DIR

	echo "Installing glide library in $LIB_DIR"
	mkdir -p $LIB_DIR
	cp $LIB_SRC_DIR/$GLIDE_LIB $LIB_DIR

	if [ -e $LIB_DIR/$GLIDE_LIB ] && [ -e $DRIVER_DIR/$THDFX_DRIVER ] 
	then
		echo "Installation successful."
	else
		echo "Installation seems to have failed. Please manually install the files as"
		echo "indicated in the README file."
	fi	
fi



