/*
** Copyright (c) 1997, 3Dfx Interactive, Inc.
** All Rights Reserved.
**
** This is UNPUBLISHED PROPRIETARY SOURCE CODE of 3Dfx Interactive, Inc.;
** the contents of this file may not be disclosed to third parties, copied or
** duplicated in any form, in whole or in part, without the prior written
** permission of 3Dfx Interactive, Inc.
**
** RESTRICTED RIGHTS LEGEND:
** Use, duplication or disclosure by the Government is subject to restrictions
** as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
** and Computer Software clause at DFARS 252.227-7013, and/or in similar or
** successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
** rights reserved under the Copyright Laws of the United States.
**
*/

#include <stdlib.h>
#include <stdio.h>
#if !defined(macintosh) && !defined(__BEOS__)
#include <conio.h>
#endif
#include <assert.h>

#include <glide.h>
#include "tlib.h"


GrHwConfiguration hwconfig;
static char version[80];

static const char name[]    = "test08";
static const char purpose[] = "fogging";
static const char usage[]   = "-n <frames> -r <res>";

void main( int argc, char **argv) {
    char match; 
    char **remArgs;
    int  rv;

    GrScreenResolution_t resolution = GR_RESOLUTION_640x480;
    float                scrWidth   = 640.0f;
    float                scrHeight  = 480.0f;
    int frames                      = -1;

    GrFog_t  fogtable[GR_FOG_TABLE_SIZE];

#ifdef __BEOS__
	InitBe();
#endif
   /* Process Command Line Arguments */
    while( rv = tlGetOpt( argc, argv, "nr", &match, &remArgs ) ) {
        if ( rv == -1 ) {
            printf( "Unrecognized command line argument\n" );
            printf( "%s %s\n", name, usage );
            printf( "Available resolutions:\n%s\n",
                    tlGetResolutionList() );
            return;
        }
        switch( match ) {
        case 'n':
            frames = atoi( remArgs[0] );
            break;
        case 'r':
            resolution = tlGetResolutionConstant( remArgs[0], 
                                                  &scrWidth, 
                                                  &scrHeight );
            break;
        }
    }

    tlSetScreen( scrWidth, scrHeight );

    grGlideGetVersion( version );

    printf( "%s:\n%s\n", name, purpose );
    printf( "%s\n", version );
    printf( "Resolution: %s\n", tlGetResolutionString( resolution ) );
    if ( frames == -1 ) {
        #if defined(macintosh)
		printf( "Click the mouse to begin test.\n");
		while (!Button());
		#else
		printf( "Press A Key To Begin Test.\n" );
		#if defined (__BEOS__)
		tlGetCH();
		#else        
        getch();
    	#endif
    	#endif
    }
    
    /* Initialize Glide */
    grGlideInit();
    assert( grSstQueryHardware( &hwconfig ) );
    grSstSelect( 0 );
    assert( grSstWinOpen( NULL,resolution,
                       GR_REFRESH_60Hz,
                       GR_COLORFORMAT_ABGR,
                       GR_ORIGIN_UPPER_LEFT,
                       GR_SMOOTHING_ENABLE,
                       2 ) );
    
    tlConSet( tlScaleX( 0.0f ), tlScaleY( 0.0f ),
              tlScaleX( 1.0f ), tlScaleY( 1.0f ),
              60, 30, 0xffffff );

    /* Set up Render State - gouraud shading + fog */
    grColorCombine( GR_COMBINE_FUNCTION_LOCAL,
                    GR_COMBINE_FACTOR_NONE,
                    GR_COMBINE_LOCAL_ITERATED,
                    GR_COMBINE_OTHER_NONE,
                    FXFALSE );
    grFogMode( GR_FOG_WITH_TABLE );
    grFogColorValue( 0xff00ff00 );
    guFogGenerateExp( fogtable, .01f );
    grFogTable( fogtable );

    tlConOutput( "Press a key to quit\n" );
    while( frames-- ) {
        GrVertex vtxA, vtxB, vtxC;
        float wDist;

        grBufferClear( 0x00, 0, 0 );

        vtxA.x = tlScaleX( 0.0f ), vtxA.y = tlScaleY( 0.0f );
        vtxA.r = 0.0f, vtxA.g = 0.0f, vtxA.b = 64.0f;
        wDist = 20.0f;
        vtxA.oow = ( 1.0f / wDist );

        vtxB.x = tlScaleX( 0.016f ), vtxB.y = tlScaleY( 1.0f );
        vtxB.r = 0.0f, vtxB.g = 0.0f, vtxB.b = 128.0f;
        wDist = 2000.0f;
        vtxB.oow = ( 1.0f / wDist );

        vtxC.x = tlScaleX( 1.0f ), vtxC.y = tlScaleY( 0.0208f );
        vtxC.r = 0.0f, vtxC.g = 0.0f, vtxC.b = 64.0f;
        wDist = 20.0f;
        vtxC.oow = ( 1.0f / wDist );

        grDrawTriangle( &vtxA, &vtxB, &vtxC );

        tlConRender();
        grBufferSwap( 1 );
        #if defined(macintosh)
        if (Button()) frames = 0;
        #else
        if ( tlKbHit() ) frames = 0;
    	#endif
    }
    
    grGlideShutdown();
    return;
}





