
#include "PaintApp.h"
#include "Toolbox.h"
#include <stdlib.h>

rgb_color rgbBlack = {0,0,0,255};

#define bmsgToolInvocation	'tinv'

BToolbox::BToolbox(BRect r, int32 matrixX, int32 matrixY) 
	: BView(r,"Toolbox",B_FOLLOW_ALL,B_WILL_DRAW|B_FULL_UPDATE_ON_RESIZE)
{
	m_toolLooper = new BLooper("ToolLooper");
	m_selection = -1;
	m_slots = matrixX * matrixY;
	m_slotsX = matrixX;
	m_slotsY = matrixY;
	m_tools = (BTool**)malloc(sizeof(BTool*) * m_slots);
	for (int i=0;i<m_slots;i++) m_tools[i] = NULL;
	
	SetViewColor(B_TRANSPARENT_32_BIT);

	m_toolLooper->Run();
	Select(0);
};

BToolbox::~BToolbox()
{
	for (int i=0;i<m_slots;i++) 
		if (m_tools[i]) delete m_tools[i];
	free(m_tools);
	m_toolLooper->Lock();
	m_toolLooper->Quit();
};

status_t BToolbox::AddTool(BTool *tool)
{
	for (int i=0;i<m_slots;i++) {
		if (!m_tools[i]) {
			m_tools[i] = tool;
			m_toolLooper->Lock();
			m_toolLooper->AddHandler(tool);
			if (m_selection == i)
				m_toolLooper->SetPreferredHandler(tool);
			m_toolLooper->Unlock();
			Window()->Lock();
			Invalidate(ItemRect(i));
			Window()->Unlock();
			return B_OK;
		};
	};
	
	return B_ERROR;
};

BRect BToolbox::ItemRect(int item)
{
	BRect r,b=Bounds();
	float width = b.Width()+1;
	float height = b.Height()+1;
	r.left = floor(width*(item%m_slotsX)/m_slotsX);
	r.right = floor(width*((item%m_slotsX)+1)/m_slotsX)-1;
	r.top = floor(height*(item/m_slotsX)/m_slotsY);
	r.bottom = floor(height*((item/m_slotsX)+1)/m_slotsY)-1;
	return r;
};

void BToolbox::Draw(BRect updateRect)
{
	BeginLineArray(8*m_slots);

	rgb_color light = {240,240,240};
	rgb_color dark = {130,130,130};
	rgb_color ul,lr;
	for (int i=0;i<m_slots;i++) {
		BRect r = ItemRect(i);
		if (m_selection == i) {
			ul = dark;
			lr = light;
			SetHighColor(160,160,160);
		} else {
			ul = light;
			lr = dark;
			SetHighColor(190,190,190);
		};
		AddLine(r.LeftTop(),r.RightTop(),ul);
		AddLine(r.LeftTop(),r.LeftBottom(),ul);
		AddLine(r.LeftBottom(),r.RightBottom(),lr);
		AddLine(r.RightBottom(),r.RightTop(),lr);
		r.InsetBy(1,1);
		FillRect(r);
		SetHighColor(0,0,0);
		r.InsetBy(2,2);
		if (m_tools[i]) m_tools[i]->DrawIcon(this,r);
	};
	EndLineArray();
};

void BToolbox::Select(int newSelection)
{
	if (newSelection == m_selection) return;

	int32 oldSelection = m_selection;
	m_selection = newSelection;
	Window()->DisableUpdates();
	Invalidate(ItemRect(oldSelection));
	Invalidate(ItemRect(m_selection));
	Window()->EnableUpdates();

	m_toolLooper->SetPreferredHandler(m_tools[m_selection]);
};

void BToolbox::MouseDown(BPoint point)
{
	for (int i=0;i<m_slots;i++) {
		BRect r = ItemRect(i);
		if (r.Contains(point)) {
			Select(i);
			break;
		};
	};
};

void BToolbox::InvokeTool(BMessage *m)
{
	m_toolLooper->PostMessage(m,NULL);
};

BToolboxWindow::BToolboxWindow(BRect r)
	: BWindow(r,"ToolBox",
		B_FLOATING_WINDOW_LOOK,B_FLOATING_APP_WINDOW_FEEL,
		B_NOT_RESIZABLE|B_WILL_ACCEPT_FIRST_CLICK)
{
	r.OffsetTo(B_ORIGIN);
	BView *top = new BView(r,NULL,B_FOLLOW_ALL,B_WILL_DRAW);
	AddChild(top);
	top->SetViewColor(190,190,190);
	r.bottom = r.top+100;
	m_toolbox = new BToolbox(r,6,2);
	m_colorSelector = new BColorControl(BPoint(10,r.bottom+11),
		B_CELLS_32x8,6,"Color Selector",NULL,false);
	m_colorSelector->SetViewColor(190,190,190);
	m_colorSelector->SetResizingMode(B_FOLLOW_BOTTOM|B_FOLLOW_H_CENTER);
	r = m_colorSelector->Frame();
	r.left = r.top = 0;
	r.right += 10;
	r.bottom += 10;
	ResizeTo(r.Width(),r.Height());
	m_toolbox->ResizeTo(r.Width(),m_toolbox->Bounds().Height());
	top->AddChild(m_colorSelector);
	top->AddChild(m_toolbox);
};
