
#include "BitmapDocument.h"
#include "PaintApp.h"
#include "BitmapEditor.h"
#include "BitmapEditorWindow.h"
#include <MenuBar.h>
#include <MenuItem.h>
#include <Window.h>
#include <ScrollView.h>

BBitmapEditorWindow::BBitmapEditorWindow(BRect r, BBitmapDocument *bitmap)
	: BWindow(r,"BitmapEditorWindow",B_DOCUMENT_WINDOW,0)
{
	if (bitmap==NULL) {
		bitmap = new BBitmapDocument(64,64);
	};
		
	r = Bounds();
	r.bottom = r.top+15;
	m_menu = new BMenuBar(r,"MenuBar");

	BMenu *submenu = new BMenu("Bitmap");
	BMenuItem *item;
	submenu->AddItem(item = new BMenuItem(	"New",new BMessage(bmsgNewBitmap),
											'N',B_COMMAND_KEY));
	submenu->AddSeparatorItem();
	submenu->AddItem(item = new BMenuItem(	"Open",new BMessage(bmsgOpenBitmap),
											'O',B_COMMAND_KEY));
	submenu->AddSeparatorItem();
	submenu->AddItem(item = new BMenuItem(	"Save",new BMessage(bmsgSave),
											'S',B_COMMAND_KEY));
	submenu->AddItem(item = new BMenuItem(	"Save as...",new BMessage(bmsgSaveAs),
											'S',B_COMMAND_KEY|B_SHIFT_KEY));
	m_menu->AddItem(submenu);

	submenu = new BMenu("View");
	submenu->AddItem(item = new BMenuItem(	"Open new view",new BMessage(bmsgOpenView),
											'V',B_COMMAND_KEY));
	submenu->AddSeparatorItem();
	submenu->AddItem(item = new BMenuItem(	"Zoom In",new BMessage(bmsgZoomIn),
											'+',B_COMMAND_KEY));
	submenu->AddItem(item = new BMenuItem(	"Zoom Out",new BMessage(bmsgZoomOut),
											'-',B_COMMAND_KEY));
	m_menu->AddItem(submenu);

	m_menu->ResizeToPreferred();
	AddChild(m_menu);

	r = Bounds();
	r.OffsetTo(B_ORIGIN);
	r.top = m_menu->Bounds().bottom+1;
	r.bottom -= 14;
	r.right -= 14;
	m_editor = new BBitmapEditor(r,B_FOLLOW_ALL,B_WILL_DRAW|B_FRAME_EVENTS,bitmap);
		
	AddChild(m_scrollView = new BScrollView(	"BitmapScroller",m_editor,B_FOLLOW_ALL,
												0,TRUE,TRUE,B_FANCY_BORDER));

	RedoSizes();
	ResizeToMax();
};

void BBitmapEditorWindow::RedoSizes()
{
	float sizeX,sizeY;
	
	m_editor->GetMaxSize(&sizeX,&sizeY);

	float minX,maxX,minY,maxY;
	minX = 14;
	minY = 14+m_menu->Bounds().bottom+1;
	maxX = sizeX+14;
	maxY = sizeY+14+m_menu->Bounds().bottom+1;
	maxX = min(maxX,1000);
	maxY = min(maxY,1000);
	SetSizeLimits(minX,maxX,minY,maxY);
};

void BBitmapEditorWindow::ResizeToMax()
{
	float sizeX,sizeY;
	m_editor->GetMaxSize(&sizeX,&sizeY);
	sizeX += 14;
	sizeY += 14+m_menu->Bounds().bottom+1;
	ResizeTo(sizeX,sizeY);
};

void BBitmapEditorWindow::MessageReceived(BMessage *msg)
{
	switch (msg->what) {
		case bmsgZoomIn:
		case bmsgZoomOut:
			{
				float ratioX,ratioY,sizeX,sizeY,newScale;
				BRect r = m_editor->Bounds();
				m_editor->GetMaxSize(&sizeX,&sizeY);
				ratioX = r.Width() / sizeX;
				ratioY = r.Height() / sizeY;
				newScale = m_editor->Scale();
				if (msg->what == bmsgZoomIn)
					newScale *= 1.05;
				else
					newScale /= 1.05;
				m_editor->SetScale(newScale);
				RedoSizes();
				m_editor->GetMaxSize(&sizeX,&sizeY);
				sizeX = floor(ratioX*sizeX + 0.5);
				sizeY = floor(ratioY*sizeY + 0.5);
				ResizeBy(sizeX-r.Width(),sizeY-r.Height());
			}
			break;
		case bmsgOpenView:
			{
				BRect r = Frame();
				r.OffsetBy(15,15);
				BWindow *w = new BBitmapEditorWindow(r,m_editor->Document());
				w->Show();
			}
			break;
		case bmsgOpenBitmap:
		case bmsgSaveAs:
		case bmsgSave:
			{
				// An exercie for the reader...
			}
			break;
		default:
			BWindow::MessageReceived(msg);
	};
};

bool BBitmapEditorWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return TRUE;
};

