////////////////////////////////////////////////////////////////////////////////
// Signal.cpp
// ----------
// Implements the signal catching and receiving classes.
//
// Copyright 1999, Be Incorporated.   All Rights Reserved.
// This file may be used under the terms of the Be Sample Code License.

#include "Signals.h"

#include <stdio.h>

SignalSender::SignalSender(void* dat) {
	data_lock=create_sem(1,"signal data locker");
	signal_blocker=create_sem(0,"signal blocker");
	data_available=false;
	thread_running=false;
	data=dat;
}

SignalSender::~SignalSender() {
	delete_sem(data_lock);
	delete_sem(signal_blocker);
}

void SignalSender::LockData() {
	acquire_sem(data_lock);
}

void SignalSender::SendSignal() {
	data_available=true;
	if (!thread_running) {
		thread_running=true;
		release_sem_etc(signal_blocker,1,B_DO_NOT_RESCHEDULE);
	}
	release_sem(data_lock);
}

SignalCatcher::SignalCatcher(SignalSender* s) {
	sender=s;
	resume_thread(thread=spawn_thread(_TaskLoop,"signal catcher thread",B_NORMAL_PRIORITY,this));
}	

SignalCatcher::~SignalCatcher() {
	acquire_sem(sender->data_lock);
	kill_thread(thread);
	CleanUp();
	release_sem_etc(sender->data_lock,1,B_DO_NOT_RESCHEDULE);
}

int32 SignalCatcher::TaskLoop() {
	while(true) {
		acquire_sem(sender->signal_blocker);
		acquire_sem(sender->data_lock);
		do {
			UseData(); // UseData() will release the data_lock
			acquire_sem(sender->data_lock);
		} while (sender->data_available);
		sender->thread_running=false;
		release_sem_etc(sender->data_lock,1,B_DO_NOT_RESCHEDULE);
	}
}

void SignalCatcher::DataCopied() {
	sender->data_available=false;
	release_sem(sender->data_lock);
}

void SignalCatcher::CleanUp() {
}
