////////////////////////////////////////////////////////////////////////////////
// App.h
// -----
// Defines the Gamma application and main window classes.
//
// Copyright 1999, Be Incorporated.   All Rights Reserved.
// This file may be used under the terms of the Be Sample Code License.

#ifndef APP_H_
#define APP_H_

#include <Application.h>
#include <Window.h>
#include <Control.h>
#include <Bitmap.h>
#include <StringView.h>
#include <View.h>
#include <Rect.h>
#include <OS.h>

#include <math.h>
#include <stdio.h>

#include "Gamma.h"
#include "Signals.h"

class GApplication:public BApplication {
public:
	GApplication();
	void ReadyToRun();
};

class GWindow:public BWindow,public SignalSender,public SignalCatcher {
public:
	GWindow();

private:
	friend class GView;
	~GWindow();
// message-receiving functions
	bool QuitRequested();
	void DispatchMessage(BMessage*,BHandler*);
	void UseNewValue(int);

// callback from SignalCatcher
	void UseData();

// functions that really process the new values
	void DisplayNewValue(int);
	void MakeBitmap(int);

// a helper function to draw the ripple pattern
	float Ripple(int x,int y);

	GammaCorrect gc;

	BBitmap* pre;
	volatile int render_val;
};

// a plain BView with a view bitmap
class GView:public BView {
public:
	GView(BRect);
	void AttachedToWindow();
};

// a custom slider
class GControl:public BControl {
public:
	GControl(BRect);
private:
	void AttachedToWindow();
	void Draw(BRect);

	void MouseDown(BPoint);
	void MouseMoved(BPoint,uint32,const BMessage*);
	void MouseUp(BPoint);
	void DoMouse(int);

	void KeyDown(const char*,int32);

	void SetValue(int32);

	BBitmap* bmp;
};

#endif // APP_H_
