/*************************************************************************
/
/	Thumbnailer.h
/
/	Written by Robert Polic
/
/	Copyright 1999, Be Incorporated.   All Rights Reserved.
/	This file may be used under the terms of the Be Sample Code License.
/
*************************************************************************/


#ifndef __THUMBNAILER__
#define __THUMBNAILER__

class Thumbnailer;
class ThumbnailView;
class ThumbnailWindow;

enum thumbnail_function
{
	eCreateThumbnail = 0,
	eForceThumbnail,
	eRemoveThumbnail
};

struct thumbnail_data
{
	entry_ref*			ref;
	Thumbnailer*		thumbnailer;
	thumbnail_function	function;
};


//========================================================================

class ThumbnailerApp : public BApplication
{
	public:
							ThumbnailerApp		();
							~ThumbnailerApp		();
		virtual void		ArgvReceived		(int32,
												 char**);
		virtual void		MessageReceived		(BMessage*);
		virtual void		ReadyToRun			();
		virtual void		RefsReceived		(BMessage*);
	private:
		void				SetStatusMessage	(const char*);

		bool				fHaveRefs;
		bool				fTerminate;
		Thumbnailer*		fThumbnailer;
		ThumbnailWindow*	fWindow;
};


//========================================================================

class ThumbnailWindow : public BWindow
{
	public:
							ThumbnailWindow		(bool* terminate);
		virtual void		MessageReceived		(BMessage*);
		virtual bool		QuitRequested		();

		void				AdjustCount			(int32);

		BStringView*		fThumbnailLabel;
		ThumbnailView*		fThumbnail;
	private:
		bool*				fTerminate;
		int32				fCount;
		BStringView*		fThumbnailsRemaining;
};


//========================================================================

class ThumbnailView : public BView
{
	public:
							ThumbnailView		(BRect,
												 const char* name);
							~ThumbnailView		();
		virtual void		Draw				(BRect);
		virtual void		MouseDown			(BPoint);
		void				SetIcons			(BBitmap* large_icon,
												 BBitmap* small_icon,
												 entry_ref*);
	private:
		BBitmap*			fLargeIcon;
		BBitmap*			fMiniIcon;
		entry_ref			fRef;
};


//========================================================================

class Thumbnailer
{
	public:
							Thumbnailer			(bool* terminate,
												 ThumbnailWindow* window = NULL);
							~Thumbnailer		();
		void				ProcessRef			(entry_ref*,
												 thumbnail_function);
	private:
		BBitmap*			ConvertBitmap		(BBitmap*,
												 BRect destintation_size,
												 color_space color = B_CMAP8,
												 bool preserve_aspect_ratio = true);
		static status_t		CreateIcon			(thumbnail_data*);
		bool				FrameLooksGood		(BBitmap*);
		BBitmap*			GetFrame			(entry_ref*);
		BBitmap*			GetImage			(entry_ref*);

		bool*				fTerminate;
		sem_id				fThumbnailerSem;
		ThumbnailWindow*	fWindow;
};

#endif
