/* ++++++++++
	test_zero - test out /dev/zero
	
+++++ */

#include <stdio.h>
#include <unistd.h>

void
main (int argc, char **arv)
{
	char 	buffer[1000];
	char	*dev_name = "/dev/my_zero";
	int		i;
	int		id;
	int		err;
	
	
	memset (buffer, 0xff, sizeof (buffer));
	
	id = open (dev_name, 0);
	if (id < 0) {
		printf ("problem opening %s\n", dev_name);
		return;
	}
	
	err = read (id, &buffer, sizeof (buffer));
	if (err < 0) {
		printf ("problem reading from %s, error = %s\n", 
			dev_name, strerror (err));
		goto err_exit;
	}
	
	for (i = 0; i < sizeof (buffer); i++)
		if (buffer[i])
			break;
	
	printf ("it %s\n", i == sizeof (buffer) ? "worked" : "didn't work");
	
err_exit:
	close (id);
}
	