/* wakelat.c
 *
 * small program for testing the latency of the wakeup driver
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <OS.h>

int
main(void)
{
	int fd;
	int i, junk;
	bigtime_t start, end;
	bigtime_t a, b;
	bigtime_t big = 0, small = B_INFINITE_TIMEOUT;
	
	fd = open("/dev/misc/wakeup", 0);
	if (fd < 0) {
		perror("open");
		return 1;
	}

	/* for this to be useful, we need to be at real-time priority */
	set_thread_priority(find_thread(NULL), B_REAL_TIME_PRIORITY);

	start = system_time();
	for (i = 0; i < 10000; i++) {
		a = system_time();
		if (read(fd, &junk, 0) < B_OK) {
			printf("read error\n");
			return 1;
		}
		b = system_time();
		big = max((b-a), big);
		small = min((b-a), small);
	}
	end = system_time();

	close(fd);

	printf("10000 cycles executed in %Ld usec (avg %Ld usec per cycle)\n",
			end - start, (end - start) / 10000);
	printf("Minimum time spent waiting: %Ld usec\n", small);
	printf("Maximum time spent waiting: %Ld usec\n", big);

	return 0;
}

