#include <GraphicsCard.h>
// for pci_info and get_nth_pci_info()
#include <PCI.h>
// for load_add_on()
#include <image.h>
// for debuging
#include <stdio.h>
#define xprintf(a) printf a

// Matrox's PCI vendor code
#define MATROX_VENDOR	0x102b
// the original Millennium
#define MGA_2064W		0x0519
// the Mystique (both original and -220 versions)
#define MGA_1064S		0x051a
// the Millennium-II
#define MGA_2164W		0x051b

#define S3_VENDOR	0x5333
#define S3_VIRGE	0x5631

typedef long (*ctrl_grph_card)(ulong message,void *buf);
typedef long (*draw_line_1555_bit)(long startX, long endX, long startY, long endY, ushort color, bool clip, short cxl, short cyt, short cxr, short cyb);
typedef long (*invert_rect)(long left, long top, long right, long bottom);
typedef long (*draw_rect_1555_bit)(long left, long top, long right, long bottom, ushort scolor);

extern int main(void) {
	int i = 0;
	pci_info pcii;
	long result;
	status_t status;
	image_id iid;
	area_id	 aid;
	area_info ai;
	ctrl_grph_card cgc;
	graphics_card_spec gcs;
	graphics_card_config gcc;
	graphics_card_info gci;
	graphics_card_hook hooks[B_HOOK_COUNT];
	draw_line_1555_bit dl1555;
	draw_rect_1555_bit dr1555;
	invert_rect ir;
	
	// load the add-on
	iid = load_add_on("ViRGE");
	if (iid < B_NO_ERROR) {
		xprintf(("Couldn't load ViRGE driver add-on! %d\n", iid));
		return -1;
	}
	status = get_image_symbol(iid, "control_graphics_card__FUlPv", B_SYMBOL_TYPE_TEXT, &cgc);
	if (status < B_NO_ERROR) {
		status = get_image_symbol(iid, "control_graphics_card", B_SYMBOL_TYPE_TEXT, &cgc);
		if (status < B_NO_ERROR) {
			status = get_image_symbol(iid, "__imp__control_graphics_card", B_SYMBOL_TYPE_TEXT, &cgc);
			if (status < B_NO_ERROR) {
				xprintf(("Couldn't get symbol from add-on! %d\n", status));
				return -1;
			}
		}
	}
	xprintf(("control_graphics_card is at 0x%08X\n", cgc));

#if !defined(__INTEL__)
	// io_base is the same for all cards :-(
	aid = find_area("pci_bus0_isa_io");
	//aid = find_area("isa_io");
	if (aid < B_NO_ERROR) {
		xprintf(("couldn't get area_id for pci_bus0_isa_io: %d\n", aid));
		return -1;
	}
	get_area_info(aid, &ai);
	gcs.io_base = ai.address;
	xprintf(("io_base is 0x%08X\n", gcs.io_base));
#endif
	// find pci card with S3 vendor and device id
	while (get_nth_pci_info(i++, &pcii) == B_NO_ERROR) {
		if ((pcii.vendor_id == S3_VENDOR) && (pcii.device_id == S3_VIRGE)) {
			xprintf(("Found ViRGE card at pci slot %d\n", i-1));
			// configure the card
			gcs.vendor_id = pcii.vendor_id;
			gcs.device_id = pcii.device_id;
			gcs.screen_base = (void *)pcii.u.h0.base_registers[0];
			result = (cgc)(B_OPEN_GRAPHICS_CARD, &gcs);
			xprintf(("result of ctrl_grph_card(B_OPEN_GRAPHICS_CARD): %d\n", result));
			gcc.space = B_16_BIT_640x480;
			gcc.refresh_rate = 60;
			gcc.h_position = gcc.v_position = gcc.h_size = gcc.v_size = 50;
			result = (cgc)(B_CONFIG_GRAPHICS_CARD, &gcc);
			xprintf(("result of ctrl_grph_card(B_CONFIG_GRAPHICS_CARD): %d\n", result));
			result = (cgc)(B_GET_GRAPHICS_CARD_INFO, &gci);
			xprintf(("result of ctrl_grph_card(B_GET_GRAPHICS_CARD_INFO): %d\n", result));
			xprintf(("frame buffer: 0x%08x\n", gci.frame_buffer));
			result = (cgc)(B_GET_GRAPHICS_CARD_HOOKS, &hooks);
			xprintf(("result of ctrl_grph_card(B_GET_GRAPHICS_CARD_HOOKS): %d\n", result));
#if 0
			dr = (draw_rect_1555_bit)hooks[41];
			(dr)(0,0,1023,767, 0x7c00);
			dl = (draw_line_1555_bit)hooks[40];
			ushort incr = 0x0001;
			ushort color = 0;
			for (int j = 0; j < 1024; j++) {
				(dl)(j, j, 100, 667, color, 0, 0, 0, 0, 0);
				color += incr;
			}
			ir = (invert_rect)hooks[11];
			(ir)(100, 50, 500, 500);
#endif
		}
	}
}
