#include <OS.h>
#include <KernelExport.h>
#include <Drivers.h>
#include <unistd.h>
#include <string.h>

int			fh;
const char* file_name = "/boot/home/cryptod_storage";
const char*	key_string = "VERY lousy encryption";
 
static void
encrypt(uchar* buf, size_t len, off_t pos)
{
	size_t			i;
	const size_t	key_len = strlen(key_string);
	
	for(i=0; i<len; i++)
		buf[i] ^= key_string[((unsigned)(pos+i))%key_len];
}

static void
decrypt(uchar* buf, size_t len, off_t pos)
{
	encrypt(buf, len, pos);
}

static status_t
cryptod_open (const char *name, uint32 flags, void **cookie)
{
	dprintf("cryptod: open()\n");
	return B_OK;
}

static status_t
cryptod_close (void *cookie)
{
	dprintf("cryptod: close()\n");
	return B_OK;
}

static status_t
cryptod_free (void *cookie)
{
	dprintf("cryptod: free()\n");
	return B_OK;
}

static status_t
cryptod_read (void *cookie, off_t pos, void *buf, size_t *len)
{
	dprintf("cryptod: read(%Ld, %d)\n", pos, *len);
	
	if(-1 == lseek(fh, pos, SEEK_SET))
	{
		*len = 0;
		return B_DEV_SEEK_ERROR;
	}
	
	if (-1 == (*len = read(fh, buf, *len)))
	{
		*len = 0;
		return B_DEV_READ_ERROR;
	}
	decrypt((uchar*)buf, *len, pos);
	return B_OK;
}

static status_t
cryptod_write (void *cookie, off_t pos, const void *buf, size_t *len)
{
	dprintf("cryptod: write(%Ld, %Ld)\n", pos, *len);
	
	if(-1 == lseek(fh, pos, SEEK_SET))
	{
		*len = 0;
		return B_DEV_SEEK_ERROR;
	}

	encrypt((uchar*)buf, *len, pos);	
	if (-1 == (*len = write(fh, buf, *len)))
	{
		*len = 0;
		return B_DEV_WRITE_ERROR;
	}
	return B_OK;
}

static status_t
cryptod_readv (void *cookie, off_t pos, const iovec *vec, size_t count, size_t *len)
{
	size_t	i;
	off_t	cur_pos;
	
	dprintf("cryptod: readv(%Ld, %d, %d)\n", pos, count, *len);

	if(-1 == lseek(fh, pos, SEEK_SET))
	{
		*len = 0;
		return B_DEV_SEEK_ERROR;
	}
	
	if (-1 == (*len = readv(fh, vec, count)))
	{
		*len = 0;
		return B_DEV_READ_ERROR;
	}
	
	for(cur_pos=pos,i=0; i<count; i++)
	{
		decrypt((uchar*)vec[i].iov_base, vec[i].iov_len, cur_pos);
		cur_pos += vec[i].iov_len;
	}
	return B_OK;
}

static status_t
cryptod_writev (void *cookie, off_t pos, const iovec *vec, size_t count, size_t *len)
{
	size_t	i;
	off_t	cur_pos;
	
	dprintf("cryptod: writev(%Ld, %d, %d)\n", pos, count, *len);

	if(-1 == lseek(fh, pos, SEEK_SET))
	{
		*len = 0;
		return B_DEV_SEEK_ERROR;
	}
	
	if (-1 == (*len = writev(fh, vec, count)))
	{
		*len = 0;
		return B_DEV_WRITE_ERROR;
	}
	
	for(cur_pos=pos,i=0; i<count; i++)
	{
		encrypt((uchar*)vec[i].iov_base, vec[i].iov_len, cur_pos);
		cur_pos += vec[i].iov_len;
	}
	return B_OK;
}

static status_t
cryptod_control(void *cookie, uint32 msg, void *buf, size_t len)
{
	return B_DEV_INVALID_IOCTL;
}

static device_hooks cryptod_device = {
	&cryptod_open,
	&cryptod_close,
	&cryptod_free,
	&cryptod_control,
	&cryptod_read,
	&cryptod_write,
	NULL,			/* select */
	NULL,			/* deselect */
	cryptod_readv,
	cryptod_writev
};

static char *cryptod_name[] = {
	"misc/cryptodevice",
	NULL
};

status_t
init_driver()
{
	dprintf("cryptod: init_driver(), %s, %s\n", __DATE__, __TIME__);
			
	if(-1 == (fh=open(file_name, O_RDWR| O_CREAT)))
		return B_ERROR;
	return B_OK;
}

void
uninit_driver()
{
	dprintf("cryptod: uninit_driver()\n");
	close(fh);
}

const char **
publish_devices()
{
	return (const char **)&cryptod_name;
}

device_hooks *
find_device(const char *name)
{
	return &cryptod_device;
}

