/* Copyright 2000, Be Incorporated. All Rights Reserved.
** This file may be used under the terms of the Be Sample Code License.
*/

#include "CPiA.h"

#include <OS.h>

#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>

const char devPath[] = "/dev/video/usb/CPiA/0";

int main(void)
{
	status_t err;
	area_id buf_id;
	size_t temp;
	cpia_capture_info info;

	int fd = open(devPath, O_RDWR);
	if (fd < 0) {
		printf("Error opening device \"%s\".\n", devPath);
		return 0;
	}
	printf("fd is %d.\n", fd);
	
	info.video_size = VIDEO_SIZE_QCIF;
	info.subsampling = SUBSAMPLING_422;
	info.yuv_order = YUV_ORDER_YUYV;
	
	temp =
		/* number of pixels */
		((info.video_size == VIDEO_SIZE_CIF) ? 352*288 : 176*144)
		/* 2 bytes per pixel in 4:2:2, 1 byte per in 4:2:0 */
		* ((info.subsampling == SUBSAMPLING_422) ? 2 : 1)
		/* 2 length bytes and one EOL byte per line */
		+ 3*((info.video_size == VIDEO_SIZE_CIF) ? 288 : 144)
		/* video frame header */
		+ 64
		/* 4 0xFF bytes signify end of frame */
		+ 4;
		
	/* The area size needs to be the next integer multiple of B_PAGE_SIZE
	** greater than temp.
	*/
	info.buf_size = (temp + B_PAGE_SIZE - 1) & ~(B_PAGE_SIZE - 1);
	printf("Asking for an area of size %ld.\n", info.buf_size);
	buf_id = create_area("buf", (void**)&info.buf, B_ANY_ADDRESS,
		info.buf_size,
		B_CONTIGUOUS, B_READ_AREA | B_WRITE_AREA);
	printf("buf %lx at %p.\n", buf_id, info.buf);
	if (buf_id < 0) {
		err = buf_id;
		goto cleanup1;
	}
		
	err = ioctl(fd, CPIA_GRAB_1_FRAME, &info);
	printf("ioctl(fd, %d, %p) returned %lx\n", CPIA_GRAB_1_FRAME, &info, err);
	
	delete_area(buf_id);
	
cleanup1:
	close(fd);

	return err;
}
