/* Copyright 2000, Be Incorporated. All Rights Reserved.
** This file may be used under the terms of the Be Sample Code License.
*/

#ifndef _CPIA_PRIV_H_
#define _CPIA_PRIV_H_

#include <OS.h>
#include <USB.h>

#define DEVICE_NAME "CPiA"
#define DEVICE_PATH "video/usb/" DEVICE_NAME "/"
#define ID DEVICE_NAME ": " /* prefix for debug messages */

#define VENDOR_ID 0x0553
#define PRODUCT_ID 0x0002

#define MAX_NUM_DEVS 1

#define MAX_NUM_QUEUED_PACKETS 1
#define NUM_BUFFERS 1

/* packet 'o device-specific data */
typedef struct device device;
struct device {
	usb_device*		dev; /* opaque handle */
	bool			connected; /* is the device plugged into the USB? */
	int32			open_count; /* number of clients of the device */
	int32			num; /* instance number of the device */
	uchar			vers[4]; /* data returned from GetCPIAVersion command */
	sem_id			lock; /* synchronize access to the device */
	sem_id			cmd_complete; /* becomes available on completion of CPiA command */
	uchar*			buf; /* data returned from CPiA command */
	size_t			actual_len; /* length of data returned by command */
	status_t		cmd_status; /* result of command */
	/* temp */
	usb_pipe*		video_in;
	uint16			max_packet_size;
};

#endif /* #ifndef _CPIA_PRIV_H_ */