/* Copyright 2000, Be Incorporated. All Rights Reserved.
** This file may be used under the terms of the Be Sample Code License.
*/

#ifndef _CPIA_H_
#define _CPIA_H_

#include <Drivers.h>

enum {
	CPIA_GRAB_1_FRAME = B_DEVICE_OP_CODES_END+1,
	CPIA_START_CAPTURE, 
	CPIA_WAIT_FOR_FRAME,
	CPIA_STOP_CAPTURE 
};

typedef struct cpia_capture_info cpia_capture_info;
struct cpia_capture_info {
	uint16 video_size;
	uint16 subsampling;
	uint16 yuv_order;
	void* buf;
	size_t buf_size;
};

#define VIDEO_SIZE_QCIF 0x00 	/* 176 x 144 */
#define VIDEO_SIZE_CIF 0x01		/* 352 x 288 */

#define SUBSAMPLING_420 0x00	/* 4:2:0 */
#define SUBSAMPLING_422 0x01	/* 4:2:2 */

#define YUV_ORDER_YUYV 0x00
#define YUV_ORDER_UYVY 0x01

#endif /* #ifndef _CPIA_H_ */