
#include <Application.h>
#include <Bitmap.h>
#include <Message.h>
#include <OS.h>
#include <StopWatch.h>
#include <Store.h>
#include <stdio.h>
#include <string.h>

#include "bempeg.h"
#include "efbitmap.h"
#include "globals.h"
#include "mpeg.h"

rgb_color kBlack = {0,0,0,255};
rgb_color kWhite = {255,255,255,255};

//FILE       *mpeg;
BFile	*mpeg;
record_ref mpeg_ref;
ImageDesc   img;
bool     moreframes = TRUE;
bool	continuePlaying = TRUE;
pixel_buffer aFrame;
pixel_buffer	fScreen;
frame_buffer_info *frameBuffer;
AMPEGWindow *mainWindow;

thread_id playThreadID;

void
play();

void 
stop();
 
/*

*/
static void
clearScreen(rgb_color *aColor)
{
	printf("clearScreen: width: %d\n",fScreen.width);
	printf("clearScreen: height: %d\n",fScreen.height);
	printf("clearScreen: bytes_per_row: %d\n",fScreen.bytes_per_row);
	printf("clearScreen: mode: 0x%8x\n",fScreen.mode);
	printf("clearScreen: buffer: 0x%8x\n",fScreen.pixels);
	
	//Y2DClear32(&fScreen, aColor);

	Y2DRectFill32(0, 0,fScreen.width-1, (fScreen.height-1)/2,&kBlack, &fScreen);
	Y2DRectFill32(0, (fScreen.height-1)/2,fScreen.width-1, (fScreen.height-1)/2,&kWhite, &fScreen);


}

static long
playMovie(void *data)
{
	double framecount=0;
	double startTime;
	double endTime;
	
	moreframes = TRUE;
	continuePlaying = TRUE;
	
	int xOffset = (fScreen.width - img.Width)/2;
	int yOffset = (fScreen.height - img.Height)/2;
	//int xOffset = 0;
	//int yOffset = 0;

	//while (continuePlaying)
	//{
		framecount = 0;
		startTime = system_time();
		
		//for (int counter = 0; counter < 253; counter++)
		while (moreframes && continuePlaying)
		{
			moreframes = GetMPEGFrame (aFrame.pixels);
			/*	 printf ("checksum: %d\n", ImageChecksum (&img, (char *)pixels));      */
			//printf("Displaying frame: %d\n",framecount);
			framecount += 1.0;
			aFrame.pixels = CurrentImage;
			Y2DCopyRect32(&fScreen, &aFrame, 0, 0, img.Width-2, img.Height-2,xOffset, yOffset);
		
			//continuePlaying = FALSE;
		}
		endTime = system_time();
		
		printf("Total Seconds: %g\n",(endTime-startTime)/1000000);
		printf("Total Frames: %g\n",framecount);
		printf("Frame Rate: %g\n",framecount/((endTime-startTime)/1000000));
			
		//RewindMPEG (mpeg, &img);
		//moreframes = TRUE;
   //}

	return 0;
}

void
play()
{
	//playThreadID = spawn_thread(playMovie, 
	//	"bempeg", B_REAL_TIME_PRIORITY, 0);
	//resume_thread(playThreadID);
	playMovie("bempeg");
}

void
stop()
{
	continuePlaying = FALSE;
}

/*
*/

AMPEGWindow::AMPEGWindow (long space, char *name)
	: BWindowScreen(name,space)
{
}

void AMPEGWindow::Quit()
{
	Disconnect();
	
	// Quit the WindowScreen.
	BWindowScreen::Quit();
}

void AMPEGWindow::ScreenConnected(bool active)
{
	if (active)
	{
		// Get the screen so we can use it
		fScreen.mode = B_RGB_32_BIT;
		fScreen.pixels = (char *)CardInfo()->frame_buffer;
		fScreen.bytes_per_row = CardInfo()->bytes_per_row;
		fScreen.width = CardInfo()->width;
		fScreen.height = CardInfo()->height;
	
		aFrame.bytes_per_row = img.Size/img.Height;
		aFrame.mode = B_RGB_32_BIT;
		aFrame.width = img.Width;
		aFrame.height = img.Height;
		aFrame.pixels = new char[img.Size];
		memset(aFrame.pixels, 127, img.Size);
	
		clearScreen(&kBlack);
		playMovie(0);
	
		snooze(1000000.0);
		be_app->PostMessage(B_QUIT_REQUESTED);
	}
}

//=====================================================================
// The following filter routines must be implemented so that mouse
// and keyboard actions can go somewhere.  If you don't have anything
// special to do, then just leave them empty, but they must exist.
//=====================================================================

void	
AMPEGWindow::MessageReceived(BMessage *msg)
{
	switch (msg->what) 
	{
		case B_KEY_DOWN:
		{
			long key = msg->FindLong("key");
			long aChar = msg->FindLong("char");
			switch(aChar)
			{
				case B_ESCAPE:
					be_app->PostMessage(B_QUIT_REQUESTED);
				break;

				case 'p':
					playMovie("movie");
				break;
		
				case 's':
					stop();
				break;
		
			}
		}
		break;
		
		default:
			BWindowScreen::MessageReceived(msg);
		break;
	}
	
}


// Just a standard app...
BeMPEG::BeMPEG ()
	:BApplication ('BMPG')
{}

void	
BeMPEG::ArgvReceived(int argc, char **argv)
{
	long error;
	
	printf("BeMPEG::ArgvReceived - BEGIN\n");

	if (argc != 2) 
	{
		fprintf (stderr, "Usage: %s mpegfile\n", argv[0]);
		return ;
	}

	//mpeg = fopen (argv[1], "r");
	//if (!mpeg)
	error = get_ref_for_path(argv[1], &mpeg_ref);
	mpeg = new BFile(mpeg_ref);
	mpeg->Open(B_READ_ONLY);
	
	if (!mpeg || !mpeg->IsOpen())
	{
      perror (argv[1]);
		return ;
	}
      
	if (!OpenMPEG (mpeg, &img))
	{
      fprintf (stderr, "OpenMPEG on %s failed\n", argv[1]);
		return ;
	}

	printf("Width: %d  Height: %d\n", img.Width, img.Height);
	printf("Depth: %d PixelSize: %d\n",img.Depth, img.PixelSize);
	printf("Image Size: %d\n", img.Size);
	printf("Calc Size: %d\n",img.Width*img.Height*(img.PixelSize/8));
}


void 
BeMPEG::ReadyToRun ()
{
	short width = 640;
	short height = 480;
	short bytes_per_row;
	
	printf("BeMPEG::ReadyToRun - BEGIN\n");
	// Set the initial resolution/depth, and the name visible on the workspace window
	mainWindow = new AMPEGWindow(B_32_BIT_640x480, "MPEG_play");
	
	// Abort the application if it's not possible to create a WindowScreen.
	if (mainWindow->Error() == B_ERROR) 
	{
		PostMessage(B_QUIT_REQUESTED);
		printf("BeMPEG::ReadyToRun - quitting early \n");
	}	
}

bool 
BeMPEG::QuitRequested ()
{
	// We need to quit the window, even when we got an error after construction,
	// because the window has been create, but couldn't work properly.
	mainWindow->Quit();
	return(TRUE);
}

void main ()
{
	BeMPEG *bempeg;

	// create and delete the semaphore and the application.
	bempeg = new BeMPEG();
	bempeg->Run();
	delete(bempeg);
}

