/*
//	Copyright 1996 Be Inc., All Rights Reserved.
//  Used by permission
*/

#ifndef STRINGLABEL_H
#define STRINGLABEL_H

#include <Point.h>
#include <View.h>

//========================================================================
// Class: BTSStringLabel
//
// This class serves as a lightweight way of drawing a string into any 
// view.  It is more lightweight than using a View, and it has more 
// parameters for displaying the text than a BStringView.
//========================================================================

class BTSStringLabel : public BObject
{
public:
				BTSStringLabel(const char *aString, const struct font_info, 
					const BPoint origin=BPoint(0,0));
				BTSStringLabel(const char *aString, const BPoint origin=BPoint(0,0), 
					const float fontSize=12.0, const char *fontName="Baskerville MT");
		virtual ~BTSStringLabel();
		
		void	Draw(BView* aView);
		
		void	Invalidate();
		void	Recalculate(BView *);
		
		void	SetText(const char *aString);
		void	SetAlignment(const alignment theAlignment);
		void	SetOrigin(const BPoint& origin);
		void	SetFontInfo(const struct font_info);
		void	SetFontName(const char *aFontName);
		void	SetShear(const float shear=90);
		void	SetSize(const float fontSize);
		void	SetRotation(const float rotation);
		void	SetColor(rgb_color);
		
		void	GetFontInfo(font_info *info) const;
		
protected:
	struct font_info	fFontInfo;
	rgb_color			fColor;
	alignment			fAlignment;
	char				*fString;
	BPoint				fOrigin;
	BPoint				fStartPoint;
	int					fNeedsCalculation;
	
private:
};

#endif

