/*
	
	Clock.cpp
	
	Copyright 1996 Be, Inc. All Rights Reserved.
	
	
	13 apr 94	elr	new today

*/


#include <Debug.h>

#include <fcntl.h>
#include <unistd.h>

#ifndef _MENU_ITEM_H
#include <MenuItem.h>
#endif

#ifndef _POP_UP_MENU_H
#include <PopUpMenu.h>
#endif

#include "clock.h"


main(int argc, char* argv[])
{	
	BTSClockApp *myApplication;

	myApplication = new BTSClockApp();
	myApplication->Run();
	
	delete myApplication;

	return 0;
}


BTSClockApp::BTSClockApp()
		  :BApplication('CLOK')
{
	// Create an instance of the clock window
	myWindow = new BTSClockWindow();


	// Create the menu item to turn on and off the showing
	// of the seconds.
	BPopUpMenu	*menu = MainMenu();
	BMenuItem	*item = new BMenuItem("Show Seconds", new BMessage(SHOW_SECONDS));
	item->SetTarget(this);
	item->SetMarked(TRUE);


	menu->AddItem(new BSeparatorItem(), 1);
	menu->AddItem(item, 2);
	menu->AddItem(new BSeparatorItem(), 3);

	Pulse();		// Force update
	myWindow->Show();
}

void 
BTSClockApp::MessageReceived(BMessage *msg)
{
	if (msg->what == SHOW_SECONDS) 
	{
		if (myWindow->Lock()) 
		{
			BMenuItem *item = MainMenu()->FindItem(SHOW_SECONDS);
			item->SetMarked(!item->IsMarked());
			myWindow->ShowSeconds(item->IsMarked());
			myWindow->Unlock();
		}
	} else 
	{
		BApplication::MessageReceived(msg);
	}
}
