/*
	
	cl_wind.cpp
	
	Copyright 1994 Be, Inc. All Rights Reserved.
	
*/

#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>

#include "cl_wind.h"


BTSClockWindow::BTSClockWindow()
			 :BWindow(BRect(100, 100, 183, 183), 
			 "Clock", B_TITLED_WINDOW, 
			 B_NOT_RESIZABLE | B_NOT_ZOOMABLE, B_ALL_WORKSPACES)
{
	short face = 1;
	bool secs = 1;
	int ref;
	BPoint			wind_loc;
	BRect			viewRect(0,0,82,82);

	theOnscreenView = new BTSOnscreenView(viewRect, "ClockView",22,15,41);

	// When resources can't be found, we really must quit immediately
	// here we're doing a hard exit, which isn't exactly the right thing
	// to do, but we have no cleaner way at present.
	if (theOnscreenView->Initialize() == -1)
	{
		be_app->PostMessage(B_QUIT_REQUESTED);
		exit (-1);
	}
	
	// Get the stored default settings
	ref = open("/system/settings/Clock_settings", O_RDONLY);
	if (ref >= 0) 
	{
		read(ref, (char *)&wind_loc, sizeof(wind_loc));
		read(ref, (char *)&face, sizeof(short));
		read(ref, (char *)&secs, sizeof(bool));
		close(ref);
		MoveTo(wind_loc);

		screen_info	sinfo;
		BRect		frame;
		get_screen_info(&sinfo);
		frame = Frame();
		frame.InsetBy(-4, -4);
		if (!frame.Intersects(sinfo.frame)) 
		{
			// it's not visible so reposition. I'm not going to get
			// fancy here, just place in the default location
			MoveTo(100, 100);
		}
	}


	SetPulseRate(500000.0);		// half second pulse rate

	Lock();
	AddChild(theOnscreenView);
	theOnscreenView->UseFace( face );
	ShowSeconds( secs );
	Unlock();
}

//==============================================================
// Method: QuitRequested
//
// Since this is the only window in the application, when it
// closes, we want the application to quit, but first we write
// out some default information so that when it comes up again,
// it will be located in the same position.
//
//==============================================================
bool 
BTSClockWindow::QuitRequested( void )
{
	int			ref;
	BPoint		lefttop;
	short		face;
	bool		seconds;

	mkdir("/system/settings", 0777);
	ref = creat("/system/settings/Clock_settings", 0777);
	if (ref >= 0) {
		lefttop = Frame().LeftTop();
		write(ref, (char *)&lefttop, sizeof(BPoint));
		face = theOnscreenView->ReturnFace();
		write(ref, (char *)&face, sizeof(short));
		seconds = theOnscreenView->ReturnSeconds();
		write(ref, (char *)&seconds, sizeof(bool));
		close(ref);
	}

	be_app->PostMessage(B_QUIT_REQUESTED);
	
	return(TRUE);
}

void
BTSClockWindow::ShowSeconds(bool doShow)
{
	theOnscreenView->ShowSeconds(doShow);
}
