/*
	
	cl_view.h
	
	Copyright 1994 Be, Inc. All Rights Reserved.
	
*/

#ifndef	_CL_VIEW_H_
#define _CL_VIEW_H_

#ifndef _APPLICATION_H
#include <Application.h>
#endif
#ifndef _WINDOW_H
#include <Window.h>
#endif
#ifndef _VIEW_H
#include <View.h>
#endif
#ifndef _BITMAP_H
#include <Bitmap.h>
#endif

#include <time.h>

class BTSOffscreenView : public BView 
{
public:
				BTSOffscreenView(BRect frame, char *name, short mRadius,
						short hRadius, short offset); 
	virtual			~BTSOffscreenView();

	virtual long	Initialize();
	virtual	void	AttachedToWindow();
	virtual	void	Draw();
		void	NextFace();
	
	BBitmap	*fClockFace[9];
	BBitmap	*fCenter;
	BBitmap	*fInner;
	short			fFace;
	BPoint			fMinutePoints[60];
	BPoint			fHourPoints[60];
	short			fMinutesRadius;
	short			fHoursRadius;
	short			fOffset;
	short			fHours;
	short			fMinutes;
	short			fSeconds;
	bool			fShowSeconds;
};

class BTSOnscreenView : public BView 
{
public:
				BTSOnscreenView(BRect frame, char *name, short mRadius,
						short hRadius, short offset); 
	virtual			~BTSOnscreenView();

	virtual	long	Initialize();
	virtual	void	Draw(BRect updateRect);
	virtual void	MouseDown( BPoint point);
	virtual void	Pulse();
			void	UseFace( short face );
			void	ShowSeconds( bool secs );
			short	ReturnFace( void );
			short	ReturnSeconds( void );

private:
	BBitmap				*Offscreen;
	BTSOffscreenView	*OffscreenView;
};

#endif
