/*
	
	cl_view.cpp
	
	Copyright 1994 Be, Inc. All Rights Reserved.
	
*/

#include <string.h>
#include <stdlib.h>

#include <time.h>
#include <float.h>
#include <math.h>
#include <File.h>

#ifndef _DEBUG_H
#include <Debug.h>
#endif

#ifndef _ALERT_H
#include <Alert.h>
#endif

#ifndef _RESOURCE_FILE_H
#include <ResourceFile.h>
#endif

#include "clock.h"
#include "cl_view.h"

BTSOffscreenView::BTSOffscreenView(BRect frame, char *name, short mRadius,
						short hRadius, short offset)
	:BView(frame, name, B_NOT_RESIZABLE, B_WILL_DRAW),
	fMinutesRadius(mRadius),
	fHoursRadius(hRadius),
	fOffset(offset),
	fHours(0),
	fMinutes(0),
	fSeconds(0),
	fShowSeconds(FALSE)
{
}

long
BTSOffscreenView::Initialize()
{
	BRect			theRect;
	BResourceFile	file;
	app_info		info;
	short			loop;
	void			*picH;
	long			len;
	float			counter;
	short			index;
	long			x,y;
	
	fFace = 1;
	theRect.Set(0,0,82,82);

	for (index = 0; index <= 8; index++)
		fClockFace[index] = NULL;

	if (be_app->GetAppInfo(&info) == B_NO_ERROR) {
		file.SetRef(info.ref);
		if (file.Error() == B_NO_ERROR) {
			file.Open(B_READ_ONLY);
			long error;

#if DEBUG
			error = file.Error();
			if (error)
				PRINT(("failed to open resource file (0x%x)\n", error));
#endif

			error = 0;

			for (loop = 0; loop <= 8; loop++) {
				if (picH = file.FindResource('PICT', loop+4, &len)) {
					fClockFace[loop] = new BBitmap(theRect,B_COLOR_8_BIT);
					fClockFace[loop]->SetBits(picH,len,0,B_COLOR_8_BIT);
					free(picH);
				} else {
					error = 1;
				}
			}

			theRect.Set(0,0,15,15);
			if (picH = file.FindResource('MICN', "center", &len)) {
				fCenter = new BBitmap(theRect,B_COLOR_8_BIT);
				fCenter->SetBits(picH,len,0,B_COLOR_8_BIT);
				free(picH);
			} else {
				error = 1;
			}

			theRect.Set(0,0,2,2);
			if (picH = file.FindResource('PICT', 13, &len)) {
				fInner = new BBitmap(theRect,B_COLOR_8_BIT);
				fInner->SetBits(picH,len,0,B_COLOR_8_BIT);
				free(picH);
			} else {
				error = 1;
			}

			file.Close();
			if (error) {
				return -1;
			}
		}
	}


	index = 0;

	//
	// Generate minutes points array
	//
	for (counter = 90; counter >= 0; counter -= 6,index++) {
		x = fMinutesRadius * cos(((360 - counter)/180.0) * 3.1415);
		x += 41;
		y = fMinutesRadius * sin(((360 - counter)/180.0) * 3.1415);
		y += 41;
		fMinutePoints[index].Set(x,y);
		x = fHoursRadius * cos(((360 - counter)/180.0) * 3.1415);
		x += 41;
		y = fHoursRadius * sin(((360 - counter)/180.0) * 3.1415);
		y += 41;
		fHourPoints[index].Set(x,y);
	}
	for (counter = 354; counter > 90; counter -= 6,index++) {
		x = fMinutesRadius * cos(((360 - counter)/180.0) * 3.1415);
		x += 41;
		y = fMinutesRadius * sin(((360 - counter)/180.0) * 3.1415);
		y += 41;
		fMinutePoints[index].Set(x,y);
		x = fHoursRadius * cos(((360 - counter)/180.0) * 3.1415);
		x += 41;
		y = fHoursRadius * sin(((360 - counter)/180.0) * 3.1415);
		y += 41;
		fHourPoints[index].Set(x,y);
	}

	return 0;
}

void BTSOffscreenView::NextFace()
{	
	fFace++;
	if (fFace > 8)
		fFace = 1;
};

void BTSOffscreenView::AttachedToWindow()
{
	SetFontSize(18);
	SetFontName("Times CG ATT");
}

void BTSOffscreenView::Draw()
{
BRect		bound;
short		hours;
	
	if (Window()->Lock()) {
		DrawBitmap(fClockFace[fFace],BPoint(0,0));
		
		//
		// Draw hands
		//
		SetHighColor(0,0,0);
		hours = fHours;
		if (hours >= 12)
			hours -= 12;
		hours *= 5;
		hours += (fMinutes / 12);
		StrokeLine(BPoint(fOffset,fOffset),fHourPoints[hours]);
		SetDrawingMode(B_OP_OVER);
		DrawBitmap(fCenter,BPoint(fOffset-3,fOffset-3));
		SetDrawingMode(B_OP_COPY);
		StrokeLine(BPoint(fOffset,fOffset),fMinutePoints[fMinutes]);
		SetHighColor(180,180,180);
		if (fShowSeconds)
			StrokeLine(BPoint(fOffset,fOffset),fMinutePoints[fSeconds]);
		DrawBitmap(fInner,BPoint(fOffset-1,fOffset-1));
		Window()->Unlock();
	}
}

BTSOffscreenView::~BTSOffscreenView()
{
	short	counter;
	
	for (counter = 0; counter <= 8; counter++)
		delete fClockFace[counter];
};
	
/*
 * Onscreen view object
 */
BTSOnscreenView::BTSOnscreenView(BRect rect, char *title, short mRadius, short hRadius,
							short offset)
	   		  :BView(rect, title, B_NOT_RESIZABLE, B_WILL_DRAW | B_PULSE_NEEDED)
{
	OffscreenView = new BTSOffscreenView(rect, "offclock",mRadius,hRadius,offset);
}

long
BTSOnscreenView::Initialize()
{
	if (OffscreenView->Initialize() != 0)
	{
		BAlert *alert = new BAlert("Error", "Clock: Could not find necessary resources.", "Quit");
		alert->Go();
		be_app->PostMessage(B_QUIT_REQUESTED);
		return -1;
	}
	
	Offscreen = new BBitmap(Bounds(), B_COLOR_8_BIT, TRUE);
	Offscreen->Lock();
	Offscreen->AddChild(OffscreenView);
	Offscreen->Unlock();
	OffscreenView->Draw();
	Draw(Bounds());

	return 0;
}

BTSOnscreenView::~BTSOnscreenView()
{
	delete Offscreen;
}

void BTSOnscreenView::Pulse()
{
	short		hours,minutes,seconds;
	struct tm	*loctime;
	time_t		current;

	current = time(0);
	loctime = localtime(&current);
	hours = loctime->tm_hour;
	minutes = loctime->tm_min;
	seconds = loctime->tm_sec;
	
	if (seconds != OffscreenView->fSeconds) {
		OffscreenView->fHours = hours;
		OffscreenView->fMinutes = minutes;
		OffscreenView->fSeconds = seconds;
		Draw(Bounds());
	}
}

void BTSOnscreenView::UseFace( short face )
{
	OffscreenView->fFace = face;
	Draw(Bounds());
}

void BTSOnscreenView::ShowSeconds( bool secs )
{
	OffscreenView->fShowSeconds = secs;
	Invalidate();
}

short BTSOnscreenView::ReturnFace( void )
{
	return(OffscreenView->fFace);
}

short BTSOnscreenView::ReturnSeconds( void )
{
	return(OffscreenView->fShowSeconds);
}

void BTSOnscreenView::Draw(BRect rect)
{
	time_t		current;

	OffscreenView->Draw();			// Composite the clock offscreen...
	DrawBitmap(Offscreen, BPoint(0, 0));
	current = time(0);
}

void BTSOnscreenView::MouseDown( BPoint point )
{
	BPoint	cursor;
	ulong	buttons;
	
	GetMouse(&cursor,&buttons);
	if (buttons & 0x2)
		be_app->PostMessage(SHOW_SECONDS);
	else
		OffscreenView->NextFace();
	Draw(Bounds());
};
