// $Revision: 1.1 $
//	Copyright (C)1995 Be Specific, Inc.  All rights reserved.


/*
	Author: William Adams
	Creation Date: 26 Dec 95
	
	Purpose:
	Implements the Gregorian View of a month
	Sunday = 0, Saturday = 6

	Sun Mon Tue Wed Thu Fri Sat
*/

#include <stdio.h>

#include "MonthView.h"
#include "GMCGraphics.h"

#include <Window.h>

//===================================================================
// Method: Constructor
//
// This is the typical constructor for a view.  The things
// of interest here are what flags are being set.
// FOLLOW_ALL - When the view is resized from any direction
//				grow the view in that direction.
// FULL_UPDATE_ON_RESIZE - Invalidate the entire view and not just the
//				freshly exposed portion.  We want this because otherwise
//				we would only redraw new portions, when in our case we
//				want the entire view to be drawn if the size changes.
// FRAME_EVENTS	We want to be notified when the view's size changes.
//				If we don't use this flag, then the FrameResized method
//				will not be called and we'll never know when to change
//				the size of the graphic.
//
// NOTES: If you want to see the effects of the various flags, try
//	removing them and see what happens.  Experimentation should give
//	a real clear understanding about how these things work.
//===================================================================
AMonthView::AMonthView(BRect frame, char *name) 
	: BView(frame, name, B_FOLLOW_ALL, B_FULL_UPDATE_ON_RESIZE|B_WILL_DRAW|B_FRAME_EVENTS) 	
{	
	fBackgroundGraphic = new AMonthGraphic(this);	
	SetViewColor(B_TRANSPARENT_32_BIT);
}

//===================================================================
// Method: Destructor
//
// This is the average everyday variety of destructor.
// Here we simply cleanup after ourselves.
//===================================================================

AMonthView::~AMonthView()
{
	delete fBackgroundGraphic;
}


//===================================================================
//	Method: FrameResized
//
// Since we used the FRAME_EVENTS flag in the constructor
// of this view, this method will be called automatically
// whenever the view is resized.
//
// All we do here is set the size of the graphic.
// Invalidation and subsequent re-drawing of the view will
// happen automatically because we have used the FULL_UPDATE_ON_RESIZE
// flag in the constructor.
//===================================================================

void		
AMonthView::FrameResized(float new_width, float new_height)
{
	fBackgroundGraphic->SetSize(BPoint(new_width, new_height));
}

//===================================================================
// Method: Draw
//
// This is called automatically by the view system whenever
// the view is newly exposed, or resized and things like that.
// This method simply calls the graphic, and tells it to draw.
// Since the graphic draws fairly quickly, there's really no need
// to create a backing store for the graphics to draw into, although
// this could be an optimization employed if the view becomes much
// more time consuming to draw.
//===================================================================

void
AMonthView::Draw(BRect updateRect)
{	
	fBackgroundGraphic->Draw(this);
}

