//	Copyright 1995 Be Specific Inc., All Rights Reserved.

#ifndef HELLO_VIEW_H
#include "MonthView.h"
#endif

#include <Application.h>
#include <Window.h>

//============================================================
// Class: AApplicationWindow
//
// Why create a window when all it does is implement the QuitRequested
// method?  Because the default behavior of a BWindow won't post the
// QUIT_REQUESTED message.  Thus, you'll close the window, but the
// app will still be running.
//============================================================
class AApplicationWindow : public BWindow {

public:
				AApplicationWindow(BRect frame); 
virtual	bool	QuitRequested();
};


AApplicationWindow::AApplicationWindow(BRect frame)
				: BWindow(frame, "January", B_TITLED_WINDOW, 0)
{
}

bool AApplicationWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
}

//============================================================
// This is a fairly generic and straight forward main program.
// Here the application is created and run.
//============================================================

main()
{	
	AApplicationWindow		*aWindow;
	AMonthView		*aView;
	BRect			aRect;


	//HelloApplication *myApplication;
	BApplication *myApplication;

	//myApplication = new HelloApplication();
	myApplication = new BApplication('JANR');
	
	
	// set up a rectangle and instantiate a new window
	aRect.Set(20, 20, 200, 200);
	aWindow = new AApplicationWindow(aRect);
	
	// set up a rectangle and instantiate a new view
	// view rect should be same size as window rect 
	// but with left top at (0, 0)
	aRect.OffsetTo(B_ORIGIN);
	aView = new AMonthView(aRect, "MonthView");
	
	// add view to window
	aWindow->AddChild(aView);
	
	// make window visible
	aWindow->Show();


	// Once everything is setup, start running the application.
	myApplication->Run();
	
	delete(myApplication);
	return(0);
}

