#ifndef BOLTS_SORT
#define BOLTS_SORT

#include "sequence.h"

/*
	Template implementations of:

		BubbleSort
		SelectionSort
		InsertionSort
		QuickSort
		.
		.
		.
		To Be Added:
		TreeSort
		HeapSort
*/

//
// Implementation of the BubbleSort algorithm
//
template <class AType>
void BubbleSort(ASequenceOf<AType>& theData)
{
	for (long top = theData.Length()-1; top > 0; top--)
	{
		for (unsigned long i = 0; i < top; i++)
		{
			if (theData[i+1] < theData[i])
				Swap(theData, i+1, i);
		}
	}
}

//
// Implementation of the Selection Sort algorithm
//
template<class AType>
void SelectionSort(ASequenceOf<AType>& theData)
{
	for (long top = theData.Length()-1; top > 0; top=top-1)
	{
		unsigned long largestPos = 0;
		for (int j = 1; j <= top; j++)
		{
			if (theData[largestPos] < theData[j])
				largestPos = j;
		}

		if (top != largestPos)
			Swap(theData, top, largestPos);
	}
}


//
// Implementation of the Insertion Sort algorithm
//
template <class AType>
void InsertionSort(ASequenceOf<AType>& theData)
{
	int len = theData.Length();
	for (long top = 1; top < len; top++)
	{
		for (long j = top-1; j>=0 && theData[j+1] < theData[j]; j--)
		{
			Swap(theData, j, j+1);
		}

	}
}

//======================================================
// QuickSort sorting algorithm
//======================================================

// Partitioning a sequence
template <class AType>
unsigned long Partition(ASequenceOf<AType>& aSequence, unsigned long low,
	unsigned long high, unsigned long pivotIndex)
{
	if (pivotIndex != low)
		Swap(aSequence, low, pivotIndex);

	pivotIndex = low;
	low++;

	while (low <= high)
	{
		if (aSequence[low] <= aSequence[pivotIndex])
			low++;
		else if (aSequence[high] > aSequence[pivotIndex])
			high--;
		else
			Swap(aSequence, low, high);
	}

	if (high != pivotIndex)
		Swap(aSequence, pivotIndex, high);

	return high;
}

template <class AType>
void	QuickSort(ASequenceOf<AType>& aSequence, unsigned long low, unsigned long high)
{
	if (low >= high)
		return;

	unsigned long pivotIndex = (low + high) /2;

	pivotIndex = Partition(aSequence, low, high, pivotIndex);

	// Sort the two sub sequences
	if (low < pivotIndex)
		QuickSort(aSequence, low, pivotIndex-1);

	if (pivotIndex < high)
		QuickSort(aSequence, pivotIndex+1, high);
}


template <class AType>
void	QuickSort(ASequenceOf<AType>& aSequence)
{
	unsigned long nElements = aSequence.Length();
	if (nElements > 1)
		QuickSort(aSequence, 0, nElements-1);
}


#endif

