#include "oskernel.h"
#include <stdio.h>
#include <stdlib.h>

//========================================================
//	Class: ACondition
//
//========================================================

ACondition::ACondition(const char *aName)
{
	// Create the semaphore with a thread count of
	// 0 so all threads will block.
	fSemaphore = create_sem(0,aName);
}

ACondition::ACondition(const ACondition &other)
{
	fSemaphore = other.fSemaphore;
}

ACondition::~ACondition()
{
	delete_sem(fSemaphore);
}

ACondition &
ACondition::operator = (const ACondition &other)
{
	fSemaphore = other.fSemaphore;
	return *this;
}
		
long	
ACondition::InformOne()
{
	long aCount=0;
	
	get_sem_count(fSemaphore, &aCount);
	if (aCount < 0)
		return release_sem_etc(fSemaphore, 1, 0);
	
	return 0;
}

long	
ACondition::InformAll()
{
	long aCount=0;
	//printf("ACondition::InformAll\n");
	
	get_sem_count(fSemaphore, &aCount);
	if (aCount < 0)
		return release_sem_etc(fSemaphore, abs(aCount), 0);

	return 0;
}
	
long	
ACondition::Wait()
{
	return acquire_sem(fSemaphore);
}


//========================================================
//
//========================================================

static long
AThread_mainthread(void *data)
{
	AThread *aThread = (AThread *)data;
	
  	return aThread->ThreadMain();
}

AThread::AThread(const char *aName, long aPriority)
	: fThreadID(-1)
{
	// Create the rendering thread
	fThreadID = spawn_thread(AThread_mainthread, 
		aName, aPriority, this);
}

AThread::~AThread()
{
	long exitStatus;
	
	Kill();
	WaitForExit(&exitStatus);
}

/*
extern thread_id	FindThread(const char *name); 
extern long			GetNthThreadInfo(team_id tmid, long n, thread_info *info);
*/

long
AThread::GetInfo(thread_info *info)
{
	return get_thread_info(fThreadID, info);
}

long 
AThread::ThreadMain()
{
	printf("AThread:: ThreadMain\n");
	return 0;
}

long	
AThread::Kill()
{
	return kill_thread(fThreadID);
}

long	
AThread::Resume()
{
	return resume_thread(fThreadID);
}

long	
AThread::Suspend()
{
	return suspend_thread(fThreadID);
}

long	
AThread::Rename(const char *newName)
{
	return rename_thread(fThreadID, newName);
}

long	
AThread::SetPriority(long newPriority)
{
	return set_thread_priority(fThreadID, newPriority);
}

long	
AThread::Snooze(double microseconds)
{
	return snooze(microseconds);
}

long
AThread::WaitForExit(long *exitStatus)
{
	return wait_for_thread(fThreadID, exitStatus);
}




	
