#include "lock.h"

long 
test_and_set(volatile long *addr)
{
	long old_value;
	
	old_value = write_32_swap (addr, 1);
	
	if (old_value == 0)
		return 0;
		
	return 1;
}

/*
	Class: ASpinLock

	Implements a simple spin lock.	

	Simply instantiate one of these, then call Lock, and
	Unlock to acquire and release it.  This is a quick and
	dirty binary lock which is meant for locking of very short
	critical sections where spending a few clock cycles won't
	be a big deal.  If you want more long-term locking, then
	a semaphore would be more appropriate.
*/

ASpinLock::ASpinLock()
	: fLockStatus(0)
{
}

int
ASpinLock::Lock()
{
	while (test_and_set(&fLockStatus) == 1)
		;

	return 0;
}

int
ASpinLock::Unlock()
{
	// Release the lock by setting its value to
	// 0 atomically. Assuming this does a flush
	// of any caches so that other processors get
	// the word.
	//fLockStatus = 0;
	write_32_swap (&fLockStatus, 0);

	return 0;
}


/*
	Class: ASemaphore
	
*/

ASemaphore::ASemaphore()
	: fCount(0)
{
}

// Wait
// 
// The classic P(Pend) command
void
ASemaphore::Wait()
{
	fLock.Lock();
	
	fCount--;
	
	// If the count is < 0, then the semaphore has already
	// been acquired, so the calling thread must be suspended
	// and placed onto the waiting stack.
	if (fCount < 0)
	{
		// Suspend the calling thread...
		// and push it onto the top of the stack  of waiting threads
		
		return;
	}
	
	fLock.Unlock();
}


void
ASemaphore::Signal()
{
}
