#ifndef BITARRAY_H
#define BITARRAY_H

#include "sequence.h"
class ABitSequence
{
public:
			ABitSequence(unsigned int nElements);
			ABitSequence(const ABitSequence& other);
			
			unsigned long Length() const;
			
	// Bit changing operations
	virtual	void	Set(unsigned long idx);
	virtual	void	Clear(unsigned long idx);
	virtual	int	IsSet(unsigned long idx) const;
	virtual	void	Flip(unsigned long idx);
	
	// Set Operations
	virtual	void	Add(const ABitSequence& other);				// operator |=
	virtual	void	Subtract(const ABitSequence& other);		// operator &= ~
	virtual	void	IntersectWith(const ABitSequence& other);	//	operator &=
	virtual	int	Includes(const ABitSequence& other) const;
	virtual	void	ClearAll();

protected:
	ASequenceOf<unsigned char>	fBitSequence;
	
	// Some utility routines
	unsigned long	ByteNumber(unsigned long idx) const;
	unsigned long	Mask(unsigned long idx) const;
private:

};

#endif
