#include "astring.h"
//#include <ctype.h>
//#include <assert.h>

/*
	String Utility routines
*/
unsigned long
string::CStringLength(const char *aString)
{
	unsigned long counter = 0;

	// If it's a NULL string, return length 0;
	if (!aString)
		return 0;

	while (aString[counter] != '\0')
		counter++;

	return counter;
}

/*
** Function: Truncate
**
** Purpose: truncates thestr to a length of maxlen
**	RETURN  VALUE: thestr   NOTE: thestr does get altered
*/
/*
char *
string::Truncate(char *thestr)
{
    if (thestr)
    {
        int	len;
	
		  for(len = string::CStringLength(thestr); len && isspace(thestr[len-1]); len--);
        thestr[len] = '\0';
    }

    return thestr;    
}
*/

/*
	Class: string
	
	A class that encapsulates the string utils functionality
*/

int 
string::IsBlank(const char *string)
{
	 int result = true;

    if (string)
    {
        const char *cp;

        for (cp = string, result = true; 
            *cp && (result == true); 
            cp++) 
        {
            if ((*cp != '\t') && 
                (*cp != '\r') && 
                (*cp != '\n') && 
                (*cp != ' '))
            {
                result = false;
            }
        }
    }

    return result;
}

string&
string::GetEmptyString()
{
	static string kEmptyString;

	return kEmptyString;
}



//=================================================
//	Constructors
//=================================================

string::string()
	: fBuffer(0),
	fBufferLength(0)
{
	fBufferLength = 1;

	// allocate the buffer
	fBuffer = new char[fBufferLength];
	//assert(fBuffer != 0);

	// Set the initial null character
	fBuffer[0] = '\0';
}

string::string(const string& other)
	: fBuffer(0),
	fBufferLength(0)
{
	unsigned long i;
	
	fBufferLength = other.fBufferLength;
	fBuffer = new char [fBufferLength];
	//assert(fBuffer != 0);

	// copy the values
	for (i = 0; other.fBuffer[i] != '\0'; i++)
		fBuffer[i] = other.fBuffer[i];

	fBuffer[i] = '\0';
}

string::string(const char *initial)
	: fBuffer(0),
	fBufferLength(0)
{
	unsigned long i;
	
	fBufferLength = 1+string::CStringLength(initial);

	// allocate the buffer
	fBuffer = new char[fBufferLength];
	//assert(fBuffer != 0);

	// Copy the initial values
	for (i=0; initial[i] != '\0'; i++)
		fBuffer[i] = initial[i];

	fBuffer[i] = '\0';
}

string::string(const char aChar)
{
	fBufferLength = 2;

	// allocate the buffer
	fBuffer = new char[fBufferLength];
	//assert(fBuffer != 0);

	// Copy the initial values
	fBuffer[0] = aChar;
	fBuffer[1] = '\0';
}

string::string(const unsigned long size)
	: fBufferLength(0)
{
	fBufferLength = 1+size;

	fBuffer = new char[fBufferLength];
	//assert(fBuffer != 0);

	// initialize to all null characters
	for (int i=0; i< fBufferLength; i++)
		fBuffer[i] = '\0';
}

string::~string()
{
	delete [] fBuffer;
   fBuffer = 0;
	fBufferLength = 0;
}

// Operator Overloading
string&
string::operator=(const char *aCString)
{
	unsigned long i;
	
	// Get rid of existing buffer
	delete [] fBuffer;
	fBufferLength = 1+string::CStringLength(aCString);

	// allocate the buffer
	fBuffer = new char[fBufferLength];
	//assert(fBuffer != 0);

	// Copy the initial values
	for (i=0; aCString[i] != '\0'; i++)
		fBuffer[i] = aCString[i];

	fBuffer[i] = '\0';

	return *this;
}

string&
string::operator=(const char aChar)
{
	// Get rid of existing buffer
	if (fBufferLength < 2)
	{
		delete [] fBuffer;
		fBufferLength = 2;
		// allocate the buffer
		fBuffer = new char[fBufferLength];
		//assert(fBuffer != 0);
	}

	// Copy the initial values
	fBuffer[0] = aChar;
	fBuffer[1] = '\0';

	return *this;
}

string&
string::operator=(const string& other)
{
	unsigned long i;
	
	delete [] fBuffer;
	fBufferLength = other.fBufferLength;
	fBuffer = new char [fBufferLength];
	//assert(fBuffer != 0);

	// copy the values
	for (i = 0; other.fBuffer[i] != '\0'; i++)
		fBuffer[i] = other.fBuffer[i];

	fBuffer[i] = '\0';

	return *this;
}

int
string::compare(const string& other) const
{
	// Compare our string the that passed in
	char *ourPtr = fBuffer;
	char *theirPtr = other.fBuffer;

	while ((*ourPtr != '\0') && (*ourPtr == *theirPtr))
	{
		ourPtr++;
      theirPtr++;
	}

   return *ourPtr - *theirPtr;
}

string&
string::operator+=(const string& other)
{
	int totalLength = length() + other.length();
	if (totalLength >= fBufferLength)
	{
		char * newBuffer = new char [1+totalLength];
		unsigned long counter;
		//assert(newBuffer != 0);

		// copy current values
		for (counter = 0; fBuffer[counter] != '\0'; counter++)
		{
			newBuffer[counter] = fBuffer[counter];
		}
		newBuffer[counter] ='\0';

		// Get rid of old data
		delete [] fBuffer;
		fBufferLength = 1+totalLength;
		fBuffer = newBuffer;
	}

	// Append the new data onto the end of our current string
	int counter = string::CStringLength(fBuffer);
	for (int ctr2 = 0; other.fBuffer[ctr2] != '\0'; ctr2++)
	{
		fBuffer[counter] = other.fBuffer[ctr2];
		counter++;
	}
   fBuffer[counter] = '\0';

	return *this;
}

static char nullChar;

char &
string::operator[](unsigned long idx) const
{
	if (idx >= CStringLength(fBuffer))
	{
		nullChar = '\0';
		return nullChar;
	}

	return fBuffer[idx];
}

string::operator const char * () const
{
	return fBuffer;
}

unsigned long string::length() const
{
	return fBufferLength;
}


//==================================================
// Generic operators
//==================================================
string
operator+ (const string& left, const string& right)
{
	string result(left);
	result += right;
	return result;
}

