#include <stdio.h>
#include <string.h>

#include "rraster.h"
#include <File.h>
#include "tiffio.h"

#pragma export on
char *rrasaddon_IDName();
char *rrasaddon_IDAuthor();
char *rrasaddon_IDNotice();
char *rrasaddon_IDEncoder();
char *rrasaddon_IDDecoder();
float CanCreateImage(void *bytes, long byteLen);
GfxImage *CreateImage(BFile *file);
GfxImage *CreateImage(char *file);
#pragma export off

char *IDName = "TIFF Codec";
char *IDAuthor = "William Adams";
char *IDNotice = "Copyright Be Inc. 1996, All Rights reserved.";
char *IDEncoder = "IDtiff";
char *IDDecoder = "IDtiff";

static int LoadJFIF(char *fname, GfxImage *img, int quick);

char *rrasaddon_IDName()
{
	return IDName;
}

char *rrasaddon_IDAuthor()
{
	return IDAuthor;
}

char *rrasaddon_IDNotice()
{
	return IDNotice;
}

char *rrasaddon_IDEncoder()
{
	return IDEncoder;
}

char *rrasaddon_IDDecoder()
{
	return IDDecoder;
}


//====================================================
// Function: CanReadImage
// 
// Returns a float value representing the degree to
// which this module is capable of reading the image.
// The closer it returns to 1.0, the more confident
// it is that the image can be read successfully.
//
// If the image can be read at all, then a value of 0.8
// should be returned.  If it can't be read at all, then
// a value of 0.0 should be returned.
//====================================================

float
CanCreateImage(void *data, long dataLen)
{
	if (dataLen < 3)
		return 0.0;
		
	unsigned char *dataPtr = (unsigned char *)data;
	
	if ((dataPtr[0]=='M' && dataPtr[1]=='M') ||
	   (dataPtr[0]=='I' && dataPtr[1]=='I'))
		return 1.0;

	return 0.0;
}

static GfxImage *	
TIFFCreateImage(char *filename, GfxImage *newImage)
{

	TIFF *tif = TIFFOpen(filename, "r");
	if (tif)
	{
		uint32 width, height;
		uint32 orient=0;
		
		TIFFGetField(tif, TIFFTAG_IMAGEWIDTH, &width);
		TIFFGetField(tif, TIFFTAG_IMAGELENGTH, &height);
		TIFFGetField(tif, TIFFTAG_ORIENTATION, &orient);
		
		size_t npixels = width * height;
		
		//printf("TIFFCreateBitmap - Width: %d  Height: %d Orientation: %d\n", width, height,orient);
		
		// Assign values to image
		newImage->XOffset = 0;
		newImage->YOffset = 0;
		newImage->width = width;
		newImage->height = height;
		newImage->type = B_RGB_32_BIT;
		newImage->bytes_per_row = width * 4;
		newImage->data = (unsigned char *)malloc(npixels*sizeof(uint32));
		uint32 *raster = (uint32 *)malloc(npixels*sizeof(uint32));
		unsigned char * rasterPtr = (unsigned char *)raster;
		unsigned char *pixels = newImage->data;
		
		if (raster != NULL)
		{
			if (TIFFReadRGBAImage(tif, width, height, raster, 0))
			{
				long w4 = width*4;
				for (int y=0; y < height; y++)
				{
					// Assign bits in bitmap
					int dstoffset = (height - y-1) * newImage->bytes_per_row;
					int srcoffset = y * w4;	// Image is upside down
					for (int ctr = 0; ctr < width; ctr++)
					{
						long ctr4 = ctr*4;
						
						pixels[dstoffset+(ctr4)] = ((unsigned char *)raster)[srcoffset+(ctr4)+1];	// Blue
						pixels[dstoffset+(ctr4)+1] = ((unsigned char *)raster)[srcoffset+(ctr4)+2];	// Green
						pixels[dstoffset+(ctr4)+2] = ((unsigned char *)raster)[srcoffset+(ctr4)+3];	// Red
						pixels[dstoffset+(ctr4)+3] = ((unsigned char *)raster)[srcoffset+(ctr4)+0];	// Alpha
					}
				}
			}
		}	

		TIFFClose(tif);
		
		free (raster);
	} else
		return 0;
	
	
	return newImage;
}

//====================================================
// Function: CreateImage
//
// Create a GfxImage based on a file of GIF data
//====================================================

GfxImage *
CreateImage(BFile *fp)
{
	char pathname[1024]={'\0'};
	char fname[1024];
	
	BDirectory *dir = new BDirectory;
	fp->GetPath(pathname,1023);
	//strcat(pathname,fname);
	printf("%s - Creating: %s\n", IDName, pathname);
	 
	return CreateImage(pathname);
}


GfxImage *
CreateImage(char *fname)
{
	GfxImage *newImage = (GfxImage *)malloc(sizeof(GfxImage));
	
	GfxImage *tmpImage = TIFFCreateImage(fname, newImage);
	
	return tmpImage;
}

#pragma export off
