
#include <string.h>
#include <stdio.h>
#include "rraster.h"


/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%  L S B F i r s t R e a d L o n g                                            %
%                                                                             %
%                                                                             %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Function LSBFirstReadLong reads a long value as a 32 bit quantity in
%  least-significant byte first order.
%
%  The format of the LSBFirstReadLong routine is:
%
%       value=LSBFirstReadLong(file)
%
%  A description of each parameter follows.
%
%    o value:  Function LSBFirstReadLong returns an unsigned long read from
%      the file.
%
%   o  file:  Specifies the file to read the data from.
%
%
*/
static unsigned long LSBFirstReadLong(FILE *file)
{
  unsigned char
    buffer[4];

  unsigned int
    status;

  unsigned long
    value;

  status=fread((char *) buffer,4,1,file);
  if (status == 0)
    return((unsigned long) ~0);
  value=(unsigned int) (buffer[3] << 24);
  value|=(unsigned int) (buffer[2] << 16);
  value|=(unsigned int) (buffer[1] << 8);
  value|=(unsigned int) (buffer[0]);
  return(value);
}

/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%  L S B F i r s t R e a d S h o r t                                          %
%                                                                             %
%                                                                             %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Function LSBFirstReadShort reads a short value as a 16 bit quantity in
%  least-significant byte first order.
%
%  The format of the LSBFirstReadShort routine is:
%
%       value=LSBFirstReadShort(file)
%
%  A description of each parameter follows.
%
%    o value:  Function LSBFirstReadShort returns an unsigned short read from
%      the file.
%
%   o  file:  Specifies the file to read the data from.
%
%
*/
static unsigned short LSBFirstReadShort(FILE *file)
{
  unsigned char
    buffer[2];

  unsigned int
    status;

  unsigned short
    value;

  status=fread((char *) buffer,2,1,file);
  if (status == 0)
    return((unsigned short) ~0);
  value=(unsigned short) (buffer[1] << 8);
  value|=(unsigned short) (buffer[0]);
  return(value);
}





static GfxImage *
LoadBMP(char *fname, GfxImage *image)
{
  typedef struct _BMPHeader
  {
    unsigned long
      file_size;

    unsigned short
      reserved[2];

    unsigned long
      offset_bits,
      size,
      width,
      height;

    unsigned short
      planes,
      bit_count;

    unsigned long
      compression,
      image_size,
      x_pixels,
      y_pixels,
      number_colors,
      colors_important;
  } BMPHeader;

	FILE *fp;
	BMPHeader bmp_header;

	long start_position;

	register int bit, i, x, y;

  //register RunlengthPacket *q;

  register unsigned char
    *p, *q;

  unsigned char
    *bmp_data,
    *bmp_pixels,
    magick[12];

  unsigned int
    bytes_per_line,
    image_size,
    status;

	/*
		Open image file.
	*/
	fp = fopen(fname,"r");
	if (!fp) 
		return 0;

  /*
    Determine if this is a BMP file.
  */
	status=fread((char *) magick,2,1,fp);
	//do
	//{
		/*
			Verify BMP identifier.
		*/
		start_position=ftell(fp)-2;
		if ((status == 0) || (strncmp((char *) magick,"BM",2) != 0))
			return 0; //PrematureExit("Not a BMP image file",image);
    
		bmp_header.file_size=LSBFirstReadLong(fp);
    	bmp_header.reserved[0]=LSBFirstReadShort(fp);
		bmp_header.reserved[1]=LSBFirstReadShort(fp);
		bmp_header.offset_bits=LSBFirstReadLong(fp);
		bmp_header.size=LSBFirstReadLong(fp);
		if (bmp_header.size == 12)
		{
			printf("LoadBMP - OS/2 image\n");
			/*
			OS/2 BMP image file.
			*/
			bmp_header.width=(unsigned long) LSBFirstReadShort(fp);
			bmp_header.height=(unsigned long) LSBFirstReadShort(fp);
			bmp_header.planes=LSBFirstReadShort(fp);
			bmp_header.bit_count=LSBFirstReadShort(fp);
			bmp_header.number_colors=0;
			bmp_header.compression=0;
			bmp_header.image_size=0;
		} else
		{
			printf("LoadBMP - Windows image\n");
			/*
			Microsoft Windows BMP image file.
			*/
			bmp_header.width=LSBFirstReadLong(fp);
			bmp_header.height=LSBFirstReadLong(fp);
			bmp_header.planes=LSBFirstReadShort(fp);
			bmp_header.bit_count=LSBFirstReadShort(fp);
			bmp_header.compression=LSBFirstReadLong(fp);
			bmp_header.image_size=LSBFirstReadLong(fp);
			bmp_header.x_pixels=LSBFirstReadLong(fp);
			bmp_header.y_pixels=LSBFirstReadLong(fp);
			bmp_header.number_colors=LSBFirstReadLong(fp);
			bmp_header.colors_important=LSBFirstReadLong(fp);
			
			// Advance through the end of the header in case
			// there is extra.
			for (i=0; i < ((int) bmp_header.size-40); i++)
				(void) fgetc(fp);
		}
		
		//==============================
		printf("LoadBMP - header size: %d\n", bmp_header.size);
		printf("LoadBMP - planes: %d\n", bmp_header.planes);
		printf("LoadBMP - bit_count: %d\n", bmp_header.bit_count);
		printf("LoadBMP - num_colors: %d\n", bmp_header.number_colors);
		printf("LoadBMP - compression: %d\n", bmp_header.compression);
		printf("LoadBMP - width: %d\n", bmp_header.width);
		printf("LoadBMP - height: %d\n", bmp_header.height);
		printf("LoadBMP - x res: %d\n", bmp_header.x_pixels);
		printf("LoadBMP - y res: %d\n", bmp_header.y_pixels);
		printf("LoadBMP - offset: %d\n", bmp_header.offset_bits);
		//==============================
		
		if (bmp_header.bit_count < 24)
		{
			unsigned char *bmp_colormap;
			unsigned int packet_size;
			long num_colors;
			
			/*
				Read BMP raster colormap.
			*/

			//image->colors=(unsigned int) bmp_header.number_colors;
			//if (image->colors == 0)
			//	image->colors=1 << bmp_header.bit_count;
			num_colors = bmp_header.number_colors;
			if (num_colors == 0)
				num_colors = 1 << bmp_header.bit_count;
				
			bmp_colormap=(unsigned char *)
			  malloc(4*num_colors);
			if (bmp_colormap == 0)
				return 0;  // PrematureExit("Unable to allocate memory",image);

			packet_size=4;
			
			if (bmp_header.size == 12)		// OS/2
				packet_size=3;
			
			(void) fread(bmp_colormap,packet_size,num_colors,fp);
			p=bmp_colormap;
			
			for (i=0; i < num_colors; i++)
			{
				image->palette[i].blue = bmp_colormap[i*packet_size];
				image->palette[i].green=bmp_colormap[i*packet_size+1];
				image->palette[i].red  =bmp_colormap[i*packet_size+2];
			}
			
			free((char *) bmp_colormap);
		}
		

		/*
		Read image data.
		*/
		while (ftell(fp) < (start_position+bmp_header.offset_bits))
			(void) fgetc(fp);
		
		image_size= ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;
		//image_size = bmp_header.width*bmp_header.height*3;
		
		if ((bmp_header.image_size == 0) || 
		  (bmp_header.image_size > image_size))
			bmp_header.image_size=image_size;
		bmp_data=(unsigned char *)malloc(bmp_header.image_size);
		
		if (bmp_data == (unsigned char *) NULL)
			return 0;  // PrematureExit("Unable to allocate memory",image);
		
		(void) fread((char *) bmp_data, bmp_header.image_size,1,fp);
		bmp_pixels = bmp_data;
		
		if (bmp_header.compression != 0)
		{
#if 0
			unsigned int packets;

			/*
			Convert run-length encoded raster pixels.
			*/
			packets=(unsigned int)
          (((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height);
        if (bmp_header.compression == 2)
          packets<<=1;
        bmp_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char));
        if (bmp_pixels == (unsigned char *) NULL)
          PrematureExit("Unable to allocate memory",image);
        (void) BMPDecodeImage(bmp_data,bmp_pixels,
          (unsigned int) bmp_header.compression,(unsigned int) bmp_header.width,
          (unsigned int) bmp_header.height);
        if (bmp_header.compression == 2)
          bmp_header.bit_count<<=1;
        free((char *) bmp_data);
#endif
      }

		/*
		Initialize image structure.
		*/
		image->width=(unsigned int) bmp_header.width;
		image->height=(unsigned int) bmp_header.height;
		bytes_per_line=((image->width*bmp_header.bit_count+31)/32)*4;
    
		//============================
		printf("LoadBMP - image_size: %d\n", bmp_header.image_size);
		printf("LoadBMP - bytes_per_line: %d\n", bytes_per_line);
		
		//============================
    
		switch (bmp_header.bit_count)
		{
			case 1:
			{
#if 0
			image->type = B_COLOR_8_BIT;
        /*
          Convert bitmap scanline to runlength-encoded color packets.
        */
        for (y=image->rows-1; y >= 0; y--)
        {
          p=bmp_pixels+(image->height-y-1)*bytes_per_line;
          q=image->pixels+(y*image->width);
          for (x=0; x < (image->columns-7); x+=8)
          {
            for (bit=0; bit < 8; bit++)
            {
              q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);
              q->length=0;
              q++;
            }
            p++;
          }
          if ((image->columns % 8) != 0)
            {
              for (bit=0; bit < (image->columns % 8); bit++)
              {
                q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);
                q->length=0;
                q++;
              }
              p++;
            }
          ProgressMonitor(LoadImageText,image->rows-y,image->rows);
        }
        SyncImage(image);
        break;
#endif
      }
			case 4:
			{
				image->bytes_per_row = image->width;
				image->data=(unsigned char *)malloc(image->height*image->width);
				image->type = B_COLOR_8_BIT;
				/*
				Convert PseudoColor scanline to runlength-encoded color packets.
				*/
				for (y=image->height-1; y >= 0; y--)
				{
					p=bmp_pixels+(image->height-y-1)*bytes_per_line;
					q=image->data+(y*image->width);
					for (x=0; x < (image->width-1); x+=2)
					{
						*q = (*p >> 4) & 0xf;
						q++;
						*q = (*p) & 0xf;
						p++;
						q++;
					}
					
					if ((image->width % 2) != 0)
					{
						*q = (*p >> 4) & 0xf;
						q++;
						p++;
					}
				}
				//CompressColormap(image);
				break;
			}

      case 8:
      {
#if 0
			image->type = B_COLOR_8_BIT;
        /*
          Convert PseudoColor scanline to runlength-encoded color packets.
        */
        if (bmp_header.compression == 1)
          bytes_per_line=image->columns;
        for (y=image->rows-1; y >= 0; y--)
        {
          p=bmp_pixels+(image->rows-y-1)*bytes_per_line;
          q=image->pixels+(y*image->columns);
          for (x=0; x < image->columns; x++)
          {
            q->index=(*p++);
            q->length=0;
            q++;
          }
          ProgressMonitor(LoadImageText,image->rows-y,image->rows);
        }
        SyncImage(image);
        CompressColormap(image);
        break;
#endif
      }
			case 24:
			{
				image->type = B_RGB_32_BIT;
				image->bytes_per_row = image->width*4;
				image->data=(unsigned char *)malloc(image->height*image->width*4);
				//if (image->data == 0)
					//	return 0; //  PrematureExit("Unable to allocate memory",image);
				
				for (y=0; y<image->height; y++)
				//for (y=image->height-1; y >= 0; y--)
				{
					for (x=0; x < image->width; x++)
					{
						long x4 = x*4;
						long x3 = x*3;
						long yoff = (image->height-y-1)*bytes_per_line;
						image->data[y*image->bytes_per_row+x4] = bmp_pixels[yoff+x3];
						image->data[y*image->bytes_per_row+x4+1] = bmp_pixels[yoff+x3+1];
						image->data[y*image->bytes_per_row+x4+2] = bmp_pixels[yoff+x3+2];
						image->data[y*image->bytes_per_row+x4+3] = 0xff;
					}
				}
				
				break;
			}
		
			default:
        		return 0; // PrematureExit("Not a BMP image file",image);
		}
	
    	//free(bmp_pixels);

#if 0
    /*
      Proceed to next image.
    */
    status=ReadData((char *) magick,1,2,image->file);
    if ((status == True) && (strncmp((char *) magick,"BM",2) == 0))
      {
        /*
          Allocate image structure.
        */
        image->next=AllocateImage(image_info);
        if (image->next == (Image *) NULL)
          {
            DestroyImages(image);
            return((Image *) NULL);
          }
        (void) strcpy(image->next->filename,image_info->filename);
        image->next->file=image->file;
        image->next->scene=image->scene+1;
        image->next->previous=image;
        image=image->next;
      }
#endif
  //} while ((status == True) && (strncmp((char *) magick,"BM",2) == 0));
  
/*
	// Backup to first image in sequence
	while (image->previous != (Image *) NULL)
    	image=image->previous;
*/
	
	fclose(fp);
	
	return(image);
}





#pragma export on
char *rrasaddon_IDName();
char *rrasaddon_IDAuthor();
char *rrasaddon_IDNotice();
char *rrasaddon_IDEncoder();
char *rrasaddon_IDDecoder();
float CanCreateImage(void *bytes, long byteLen);
GfxImage *CreateImage(BFile *file);
GfxImage *CreateImage(char *file);
#pragma export off

char *IDName = "BMP Codec";
char *IDAuthor = "William Adams";
char *IDNotice = "Copyright Be Inc. 1996, All Rights reserved.";
char *IDEncoder = "IDbmp";
char *IDDecoder = "IDbmp";

char *rrasaddon_IDName()
{
	return IDName;
}

char *rrasaddon_IDAuthor()
{
	return IDAuthor;
}

char *rrasaddon_IDNotice()
{
	return IDNotice;
}

char *rrasaddon_IDEncoder()
{
	return IDEncoder;
}

char *rrasaddon_IDDecoder()
{
	return IDDecoder;
}


//====================================================
// Function: CanReadImage
// 
// Returns a float value representing the degree to
// which this module is capable of reading the image.
// The closer it returns to 1.0, the more confident
// it is that the image can be read successfully.
//
// If the image can be read at all, then a value of 0.8
// should be returned.  If it can't be read at all, then
// a value of 0.0 should be returned.
//====================================================

float
CanCreateImage(void *data, long dataLen)
{
	if (dataLen < 2)
		return 0.0;
	
	char *dataPtr = (char *)data;	
	if (strncmp((char *) dataPtr, "BM", 2)==0)
		return 1.0;

	return 0.0;
}



GfxImage *
CreateImage(BFile *fp)
{
	char pathname[1024]={'\0'};
	
	fp->GetPath(pathname,1023);
	printf("%s - Creating: %s\n", IDName, pathname);
	 
	return CreateImage(pathname);
}


GfxImage *
CreateImage(char *fname)
{
	GfxImage *newImage = (GfxImage *)malloc(sizeof(GfxImage));
	
	if (LoadBMP(fname, newImage))
		return newImage;
	else
		free(newImage);
		
	return 0;
}

