#ifndef OSKERNEL_H
#define OSKERNEL_H

#include <OS.h>

//=================================================
//
//=================================================
class ACondition
{
public:
				ACondition(const char *aName);
				ACondition(const ACondition&);
				~ACondition();
				
	ACondition& operator =(const ACondition&);
	
	long	InformOne();
	long	InformAll();
	
	long	Wait();
	
protected:
	sem_id	fSemaphore;
	
private:
	ACondition();
	
};

class AThread
{
public:

/*
	static thread_id	FindThread(const char *name); 
	static long			GetNthThreadInfo(team_id tmid, long n, thread_info *info);
*/

			AThread(const char *aName, long aPriority = B_NORMAL_PRIORITY);
	virtual	~AThread();
			
	long	GetInfo(thread_info *info);
	long	Kill();
	long	Resume();
	long	Suspend();
	long	Rename(const char *newName);
	long	SetPriority(long newPriority);
	long	Snooze(double microseconds);
	long	WaitForExit (long *thread_return_value);
	
	thread_id	ThreadID() {return fThreadID;};
	
	// This is the main routine that you should implement
	// It is called by the Start() method when it's time to
	// actually start running the thread.
	virtual	long	ThreadMain();
	
protected:
	thread_id	fThreadID;
	
private:

};


#endif
