#include "images.h"
#include <InterfaceDefs.h>
#include <stdio.h>

ICONmushroom mushroom;
ICONempty empty;
ICONsnake snake;
ICONhdup hdup;
ICONhdright hdright;
ICONhddown hddown;
ICONhdleft hdleft;
ICONkiller killer;
ICONheart heart;

const unsigned char kBlack = 0; //index_for_color(0, 0, 0);
const unsigned char kWhite = 254; //index_for_color(255, 255, 255);
const unsigned char kRed = 230; //index_for_color(255, 0, 0,255);
const unsigned char kGreen = 117; //index_for_color(0, 255, 0);
const unsigned char kBlue = 128; //index_for_color(0, 0, 255);

/*
	pixel_buffer base class
*/

pixel_buffer::pixel_buffer()
{
	width = 0;
	height = 0;
	mode = 0;
	pixels = 0;
	bytes_per_row = 0;
}

pixel_buffer::pixel_buffer(const int awidth, const int aheight, const long amode)
{
	width = awidth;
	height = aheight;
	mode = amode;
	bytes_per_row = width;
	
	pixels = new unsigned char[bytes_per_row*height];

}

pixel_buffer::~pixel_buffer()
{
	//delete [] pixels;
}

void
pixel_buffer::PutPixel(const int x, const int y, const unsigned char pixval)
{
	int offset = y * bytes_per_row + x;
	pixels[offset] = pixval;
}

/* draw a line on an image straight down */
void 
pixel_buffer::draw_y_line(const int x,const int ystart,
	const int yend,const int col)
{
	int c;

	for (c=ystart; c<=yend; c++) 
		PutPixel(x,c,col);
}




/* paints an image completely black */
ICONempty::ICONempty() 
	: pixel_buffer(16,16)
{
  int x,y;
	
  for (y=0; y<16; y++) {
    for (x=0; x<16; x++) {
      PutPixel(x,y,kBlack);
    }
  }
}
      
/* function to draw mushroom graphic */
ICONmushroom::ICONmushroom() 
	: pixel_buffer(16,16)
{

  int x,y;
	unsigned char pixval;
	
  /* set image background to black */
  for (y=0; y<16; y++) {
    for (x=0; x<16; x++) {
      PutPixel(x,y,kBlack);
    }
  }

  /* draw stem in closest we have to green */
  pixval=kGreen;
  for (y=9; y<15; y++) {
    for (x=4; x<10; x++) {
      PutPixel(x,y,pixval);
    }
  }

  /* draw the 'dome' of the mushroom */
  y=8;
  for (x=1;x<13;x++) PutPixel(x,y,pixval);
  y=7;
  for (x=1;x<13;x++) PutPixel(x,y,pixval);
  y=6;
  for (x=2;x<12;x++) PutPixel(x,y,pixval);
  y=5;
  for (x=2;x<12;x++) PutPixel(x,y,pixval);
  y=4;
  for (x=3;x<11;x++) PutPixel(x,y,pixval);
  y=3;
  for (x=4;x<10;x++) PutPixel(x,y,pixval);
  y=2;
  for (x=6;x<8;x++) PutPixel(x,y,pixval);


}

/* draws snake body onto an image */  
ICONsnake::ICONsnake() 
	: pixel_buffer(16,16)
{
  int x,y;
	unsigned char pixval;
	
  /* blank entire image to blue */
  pixval=kBlue;
  for (y=0; y<16; y++) {
    for (x=0; x<16; x++) {
      PutPixel(x,y,pixval);
    }
  }

  /* trim off corners, repeating in each corner of the image */
  pixval=kBlack;

  x=0;
  for (y=0; y<6; y++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
    PutPixel(x,15-y,pixval);
    PutPixel(15-x,15-y,pixval);
  }

  x=1;
  for (y=0; y<4; y++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
    PutPixel(x,15-y,pixval);
    PutPixel(15-x,15-y,pixval);
  }

  x=2;
  for (y=0; y<3; y++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
    PutPixel(x,15-y,pixval);
    PutPixel(15-x,15-y,pixval);
  }

  x=3;
  for (y=0; y<2; y++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
    PutPixel(x,15-y,pixval);
    PutPixel(15-x,15-y,pixval);
  }

  x=4;
  for (y=0; y<1; y++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
    PutPixel(x,15-y,pixval);
    PutPixel(15-x,15-y,pixval);
  }

  x=5;
  for (y=0; y<1; y++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
    PutPixel(x,15-y,pixval);
    PutPixel(15-x,15-y,pixval);
  }

}


/* draw the snakes eyes and nose, pointing upwards */
ICONhdup::ICONhdup() 
	: ICONsnake()
{

  int x,y;
	unsigned char pixval;

  /* draw the whites of the eyes */  
  pixval=kWhite;

  PutPixel(4,4,pixval);
  PutPixel(5,4,pixval);
  PutPixel(3,5,pixval);
  PutPixel(6,5,pixval);
  PutPixel(3,6,pixval);
  PutPixel(6,6,pixval);
  PutPixel(4,7,pixval);
  PutPixel(5,7,pixval);

  PutPixel(11,4,pixval);
  PutPixel(10,4,pixval);
  PutPixel(12,5,pixval);
  PutPixel(9,5,pixval);
  PutPixel(12,6,pixval);
  PutPixel(9,6,pixval);
  PutPixel(11,7,pixval);
  PutPixel(10,7,pixval);

  /* draw the eye's pupils */
  pixval=kBlack;

  PutPixel(4,5,pixval);
  PutPixel(5,5,pixval);
  PutPixel(4,6,pixval);
  PutPixel(5,6,pixval);

  PutPixel(11,5,pixval);
  PutPixel(10,5,pixval);
  PutPixel(11,6,pixval);
  PutPixel(10,6,pixval);

  /* draw the nose */
  pixval=kRed;

  y=0;
  for (x=6; x<10; x++) {
    PutPixel(x,y,pixval);
  }

  y=1;
  for (x=6; x<10; x++) {
    PutPixel(x,y,pixval);
  }

  y=2;
  for (x=7; x<9; x++) {
    PutPixel(x,y,pixval);
  }
}


/* draw the eyes and the nose of the snake, pointing right */
ICONhdright::ICONhdright() 
	: ICONsnake()
{

  int x,y,pixval;

  /* draw the whites of the eyes */  
  pixval=kWhite;

  PutPixel(11,4,pixval);
  PutPixel(11,5,pixval);
  PutPixel(10,3,pixval);
  PutPixel(10,6,pixval);
  PutPixel(9,3,pixval);
  PutPixel(9,6,pixval);
  PutPixel(8,4,pixval);
  PutPixel(8,5,pixval);

  PutPixel(11,11,pixval);
  PutPixel(11,10,pixval);
  PutPixel(10,12,pixval);
  PutPixel(10,9,pixval);
  PutPixel(9,12,pixval);
  PutPixel(9,9,pixval);
  PutPixel(8,11,pixval);
  PutPixel(8,10,pixval);

  /* draw the pupils */
  pixval=kBlack;

  PutPixel(10,4,pixval);
  PutPixel(10,5,pixval);
  PutPixel(9,4,pixval);
  PutPixel(9,5,pixval);

  PutPixel(10,11,pixval);
  PutPixel(10,10,pixval);
  PutPixel(9,11,pixval);
  PutPixel(9,10,pixval);

  /* draw the nose */
  pixval=kRed;

  x=15;
  for (y=6; y<10; y++) {
    PutPixel(x,y,pixval);
  }

  x=14;
  for (y=6; y<10; y++) {
    PutPixel(x,y,pixval);
  }

  x=13;
  for (y=7; y<9; y++) {
    PutPixel(x,y,pixval);
  }
}


/* draws the snakes eyes and nose, pointing down */
ICONhddown::ICONhddown() 
	: ICONsnake()
{

  int x,y;
	unsigned char pixval;

  /* draws the whites of the eyes */  
  pixval=kWhite;

  PutPixel(4,11,pixval);
  PutPixel(5,11,pixval);
  PutPixel(3,10,pixval);
  PutPixel(6,10,pixval);
  PutPixel(3,9,pixval);
  PutPixel(6,9,pixval);
  PutPixel(4,8,pixval);
  PutPixel(5,8,pixval);

  PutPixel(11,11,pixval);
  PutPixel(10,11,pixval);
  PutPixel(12,10,pixval);
  PutPixel(9,10,pixval);
  PutPixel(12,9,pixval);
  PutPixel(9,9,pixval);
  PutPixel(11,8,pixval);
  PutPixel(10,8,pixval);

  /* draws the pupils */
  pixval=kBlack;

  PutPixel(4,10,pixval);
  PutPixel(5,10,pixval);
  PutPixel(4,9,pixval);
  PutPixel(5,9,pixval);

  PutPixel(11,10,pixval);
  PutPixel(10,10,pixval);
  PutPixel(11,9,pixval);
  PutPixel(10,9,pixval);

  /* draws the nose */
  pixval=kRed;

  y=15;
  for (x=6; x<10; x++) {
    PutPixel(x,y,pixval);
  }

  y=14;
  for (x=6; x<10; x++) {
    PutPixel(x,y,pixval);
  }

  y=13;
  for (x=7; x<9; x++) {
    PutPixel(x,y,pixval);
  }
}


/* draws the snake's eyes and nose, pointing left */
ICONhdleft::ICONhdleft() 
	: ICONsnake()
{

  int x,y;
	unsigned char pixval;

  /* draws the whites of the eyes */  
  pixval=kWhite;

  PutPixel(4,4,pixval);
  PutPixel(4,5,pixval);
  PutPixel(5,3,pixval);
  PutPixel(5,6,pixval);
  PutPixel(6,3,pixval);
  PutPixel(6,6,pixval);
  PutPixel(7,4,pixval);
  PutPixel(7,5,pixval);

  PutPixel(4,11,pixval);
  PutPixel(4,10,pixval);
  PutPixel(5,12,pixval);
  PutPixel(5,9,pixval);
  PutPixel(6,12,pixval);
  PutPixel(6,9,pixval);
  PutPixel(7,11,pixval);
  PutPixel(7,10,pixval);

  /* draws the pupils */
  pixval=kBlack;

  PutPixel(5,4,pixval);
  PutPixel(5,5,pixval);
  PutPixel(6,4,pixval);
  PutPixel(6,5,pixval);

  PutPixel(5,11,pixval);
  PutPixel(5,10,pixval);
  PutPixel(6,11,pixval);
  PutPixel(6,10,pixval);

  /* draws the nose */
  pixval=kRed;

  x=0;
  for (y=6; y<10; y++) {
    PutPixel(x,y,pixval);
  }

  x=1;
  for (y=6; y<10; y++) {
    PutPixel(x,y,pixval);
  }

  x=2;
  for (y=7; y<9; y++) {
    PutPixel(x,y,pixval);
  }
}


/* draws the skull onto an image */
ICONkiller::ICONkiller() 
	: pixel_buffer(16,16)
{
  int x,y;
	unsigned char pixval;

  /* blanks the image to black */
  pixval=kBlack;
  for (y=0; y<16; y++) {
    for (x=0; x<16; x++) {
      PutPixel(x,y,pixval);
    }
  }

  /* draws the skull */
  pixval=kWhite;

  y=2;
  for (x=5; x<8; x++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
  }

  y=3;
  for (x=4; x<8; x++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
  }

  y=4;
  for (x=3; x<5; x++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
  }

  x=8;
  PutPixel(x,y,pixval);
  PutPixel(15-x,y,pixval);

  y=5;
  for (x=3; x<5; x++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
  }

  x=8;
  PutPixel(x,y,pixval);
  PutPixel(15-x,y,pixval);

  y=6;
  for (x=4; x<8; x++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
  }

  y=7;
  for (x=5; x<7; x++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
  }

  y=8;
  for (x=6; x<8; x++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
  }

  y=9;
  for (x=6; x<7; x++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
  }

  y=10;
  for (x=6; x<7; x++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
  }

  y=11;
  for (x=6; x<8; x++) {
    PutPixel(x,y,pixval);
    PutPixel(15-x,y,pixval);
  }
}


/* organises the drawing of the snake's head rotated to the four positions
onto the right images */

/* draw the heart onto an image */
ICONheart::ICONheart() 
	: pixel_buffer(16,16)
{

  int pixval;

  /* clear image to black */
  int x,y;
	
  for (y=0; y<16; y++) {
    for (x=0; x<16; x++) {
      PutPixel(x,y,kBlack);
    }
  }

  /* draw heart */
  pixval=kRed;
  draw_y_line(2,5,7,pixval); draw_y_line(12,5,7,pixval);
  draw_y_line(3,4,9,pixval); draw_y_line(11,4,9,pixval);
  draw_y_line(4,4,11,pixval); draw_y_line(10,4,11,pixval);
  draw_y_line(5,5,12,pixval); draw_y_line(9,5,12,pixval);
  draw_y_line(6,6,14,pixval); draw_y_line(8,6,14,pixval);
  draw_y_line(7,7,15,pixval);

  /* draw highlights onto heart */
  pixval=kWhite;
  PutPixel(3,6,pixval); PutPixel(4,5,pixval);
  PutPixel(9,6,pixval); PutPixel(10,5,pixval);
}

