#ifndef GAMESTICK_H
#define GAMESTICK_H

#include <Joystick.h>
#include "atime.h"

enum {
	BUTTON1 = 1,
	BUTTON2 = 2
};

enum EGamePort {
	GAMEPORT1,
	GAMEPORT2,
	GAMEPORT3,
	GAMEPORT4
};

class GameStick
{
public:
				GameStick();
				GameStick(EGamePort);
		
		void	Initialize(const char *whichone);
		bool	IsValid();
		long	FindZero(float &x, float &y);
		void	Train();
		
		void	GetPosition(float &x, float &y);
		void	GetAbsolutePosition(short &x, short &y);
		void	GetZeroPosition(short &x, short &y);
		bool	IsButtonPressed(const long whichbutton);
		
protected:
	BJoystick	fJoystick;
	bool	fIsValid;
	float	fZeroX;
	float	fZeroY;
	float	fMinX;
	float	fMaxX;
	float	fMinY;
	float	fMaxY;
	
	float	fMinXRange;
	float	fMinYRange;
	float	fMaxXRange;
	float	fMaxYRange;
	float	fLastX;
	float	fLastY;
	double	fLastTimestamp;
	
private:
	GameStick(const GameStick &);			// No copy constructor
	GameStick& operator =(const GameStick &);	// No assignment
};


class GameStickThread : public ATicker
{
public:
			GameStickThread();
			
	virtual	void	Tick(const double tickCount);
	
protected:
	GameStick	fGameStick;
	
private:

};

#endif
