#ifndef GAMESTATE_H
#define GAMESTATE_H

#include <Application.h>
#include <Handler.h>
#include <Looper.h>

class GameClock;
class GameHandler;
class GameState;
class GameStickThread;
class GameView;

/* length of snake's postion history buffer */
#define HISTLENGTH (1024)

/* possible values for the playing area map */
enum mtype { UNSET, EMPTY,MUSH,SNAKE,KILL,HDUP,HDRIGHT,HDDOWN,HDLEFT,HEART };

/* possible game states */
enum gstate { INGAME=1, PAUSED=2, DYING=4, NEWLEVEL=8, WIN=16 };


/* structure to hold position information */
typedef struct point 
{
  int x;
  int y;
} point;

enum EGameCommand {
	MPNONE = 1000,
	MPQUIT,
	MPNEWGAME,
	MPPAUSE,
	MPCONTINUE,
	MPTOGGLEPAUSE,
	MPMOVELEFT,
	MPMOVERIGHT,
	MPMOVEUP,
	MPMOVEDOWN
};


class GameEngine : public BApplication
{
public:
			GameEngine(const unsigned long width, const unsigned long height);
			~GameEngine();
			
	// Inherited from BLooper
	virtual	void	MessageReceived(BMessage *message);

	// Inherited from BApplication
	virtual	void	Pulse();
	virtual void	ReadyToRun();
	virtual bool	QuitRequested();


	void	GetSize(unsigned long &width, unsigned long &height);	
	
	GameClock	*fGameClock;
	GameHandler	*fGameHandler;
	GameState	*fGameState;
	GameView *fGamePresenter;
	bool		fIsQuitting;
	
	void	TurnClockwise();
	void	TurnCounterClockwise();
	void	MoveUp();
	void	MoveDown();
	void	MoveLeft();
	void	MoveRight();
	void	TogglePause();
	void	Pause();
	void	Continue();

protected:
	GameStickThread	*fGameStickThread;
	long	fWidth;
	long	fHeight;
	
	
private:
};

class GameState
{
public:
			GameState(const unsigned long width, const unsigned long height);
			~GameState();
			
			void Initialize();
			void setup_map_memory();
			void make_map(int mush,int death,int hearts);
			void update_game();
			void NewGame();
			
	int gamestate;		// enum gstate, Game's current playing status

	enum mtype *map;			//pointer to permanent map
	//enum mtype sdir;			// direction snake is heading in
	int sdir;
	point spos;					// current position of snake's head
	point shist[HISTLENGTH];	// buffer for past positions of snake's head
	int shistoff;				// & current buffer offset
	int slength;				// length of snake
	int dcount;					//counter for the snake death animation
	unsigned long width;					// size of game area, in 16 pixel units
	unsigned long height;
	int difficulty;				// difficulty level
	int speed; 					// factor to slow game by
	int mushnum;				// number of mushrooms left
	int walls;					// can you wrap around?

protected:
private:
};

extern GameEngine *gGameEngine;

#endif
