//
// StickIt
//
// File: main.c
//
// BJoystick class demonstration program.
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <Joystick.h>
#include <String.h>

#include "jwindow.h"
#include "japplication.h"

BJoystick *stick;

bool PickJoystick(BJoystick *stick);

int main(void) {
	BString name;
	JApplication app;
	
	printf("StickIt -- BJoystick demo for BeOS\n\n");
	
	stick = new BJoystick;
	if (!PickJoystick(stick)) {
		return 1;
	}
	
	stick->GetControllerName(&name);
	printf("You chose the %s.  Excellent choice.\n\n", name.String());
	
	app.theWindow = new JWindow(stick);
	app.theWindow->Show();
	
	app.Run();
	return 0;
}

//
// PickJoystick
//
// Present a list of all game controllers and let the
// user choose the one to use.  This will configure
// the "stick" object for that controller.
//
bool PickJoystick(BJoystick *stick) {
	int32 numDevices;
	int32 i;
	char devName[B_OS_NAME_LENGTH];
	BString name;
	int choice;
	
	numDevices = stick->CountDevices();		// How many devices?
	if (!numDevices) {
		printf("*** No game ports detected.\n");
		return false;
	}
	
	choice = 0;
	do {
		printf("There are %ld gameports available:\n", numDevices);
		for (i=0; i<numDevices; i++) {
			if (stick->GetDeviceName(i, devName) != B_OK) {
				printf("*** Error while reading controller list.\n");
				return false;
			}
			if (stick->Open(devName, true) < B_OK) {
				printf("%4ld. No controller on %s.\n", i+1, devName);
			}
			else {
				if (stick->GetControllerName(&name) != B_OK) {
					printf("*** Can't get name of controller %s.\n", devName);
					return false;
				}
				printf("%4ld. %s\n", i+1, name.String());
				stick->Close();
			}
		}
		
		do {
			printf("\nChoose one: ");
			scanf("%d", &choice);
			if (choice <= 0 || choice > numDevices) {
				printf("That's not a valid option.  Try again.\n");
				choice = 0;
			}
		} while (!choice);
		
		// Open the chosen stick.
		
		if (stick->GetDeviceName(choice-1, devName) != B_OK) {
			printf("*** Can't use that stick.  Try again.\n");
			choice = 0;
		}
		
		if (stick->Open(devName, true) < B_OK) {
			printf("*** No controller connected on that port.  Try again.\n");
			choice = 0;
		}
	} while (!choice);
	return true;
}