//
// StickIt
//
// File: jwindow.cpp
//
// Joystick window.
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <OS.h>

#include "jwindow.h"

rgb_color rgb_black = {0, 0, 0, 255};
rgb_color rgb_red = {255, 0, 0, 255};

JWindow::JWindow(BJoystick *stick) :
			BWindow(BRect(50,50,405,350), "StickIt", B_TITLED_WINDOW,
						B_NOT_RESIZABLE|B_NOT_ZOOMABLE) {
	view = new JView(Bounds(), stick);
	view->SetViewColor(216, 216, 216);
	view->SetLowColor(216, 216, 216);
	ResizeTo(view->Bounds().Width(), view->Bounds().Height());
	AddChild(view);
	SetPulseRate(100000.0);
}

bool JWindow::QuitRequested(void) {
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}

int32 hatX[9] = {
	10, 10, 20, 20, 20, 10, 0, 0, 0
};

int32 hatY[9] = {
	10, 0, 0, 10, 20, 20, 20, 10, 0
};

JView::JView(BRect frame, BJoystick *stick) :
	BView(frame, "jview", B_FOLLOW_ALL_SIDES, B_WILL_DRAW|B_PULSE_NEEDED) {
	BString name;
	int32 i;
	int32 numButtons;
	int32 numHats;
	int32 numAxes;
	BStringView *sview;
	BRect r;
	float col1bot;

	BStringView *stickName;
	
	// Set up the controls
	
	this->stick = stick;
	stick->GetControllerName(&name);
	stickName = new BStringView(BRect(5,5,350, 25), "stickname", name.String());
	stickName->SetFontSize(18);
	AddChild(stickName);
	
	// Labels
	
	numButtons = stick->CountButtons();
	r.Set(5,50,100, 64);
	for (i=0; i<numButtons; i++) {
		stick->GetButtonNameAt(i, &name);
		name.Append(":");
		sview = new BStringView(r, "buttonlabel", name.String());
		sview->SetAlignment(B_ALIGN_RIGHT);
		sview->SetFont(be_bold_font);
		AddChild(sview);
		r.top += 18;
		r.bottom += 18;
	}
	
	numHats = stick->CountHats();
	r.top += 15;
	r.bottom += 15;
	for (i=0; i<numHats; i++) {
		stick->GetHatNameAt(i, &name);
		name.Append(":");
		sview = new BStringView(r, "hatlabel", name.String());
		sview->SetAlignment(B_ALIGN_RIGHT);
		sview->SetFont(be_bold_font);
		AddChild(sview);
		r.top += 40;
		r.bottom += 40;
	}
	
	col1bot = r.bottom - 30;
	numAxes = stick->CountAxes();
	
	// We assume that the first two axes are the x and y axes.
	
	r.Set(130, 50, 195, 64);
	sview = new BStringView(r, "sticklabel", "Stick:");
	sview->SetFont(be_bold_font);
	sview->SetAlignment(B_ALIGN_RIGHT);
	AddChild(sview);
	
	// Now make labels for all the solitary axes
	
	r.Set(130, 220, 195, 234);
	for (i=2; i<numAxes; i++) {
		stick->GetAxisNameAt(i, &name);
		name.Append(":");
		sview = new BStringView(r, "axislabel", name.String());
		sview->SetAlignment(B_ALIGN_RIGHT);
		sview->SetFont(be_bold_font);
		AddChild(sview);
		r.top += 18;
		r.bottom += 18;
	}

	lastHatRect.Set(0,0,0,0);
	if (r.bottom-10 > col1bot) {
		if (i == 2) {
			col1bot = 205;
		}
		else {
			col1bot = r.bottom - 10;
		}
	}
	ResizeTo(355, col1bot);
}

void JView::Pulse(void) {
	Window()->Lock();
	Draw(Bounds());
	Window()->Unlock();
}

void JView::Draw(BRect updateRect) {
	int32 i;
	int32 numButtons;
	int32 numHats;
	int32 numAxes;
	BRect r;
	uint8 *hats;
	int16 *axes;
	BRect curHatRect;
	float x, y;
	uint32 buttons;
	
	numButtons = stick->CountButtons();
	numHats = stick->CountHats();
	numAxes = stick->CountAxes();
	axes = (int16 *) malloc(sizeof(int16) * numAxes);
	hats = (uint8 *) malloc(numHats);
	stick->Update();
	
	// Buttons first
	
	r.Set(105,50,115,60);
	buttons = stick->ButtonValues();
	for (i=0; i<numButtons; i++) {
		if (buttons & (1 << i)) {
			FillRect(r, B_SOLID_HIGH);
		}
		else {
			r.InsetBy(1,1);
			FillRect(r, B_SOLID_LOW);
			r.InsetBy(-1,-1);
			StrokeRect(r, B_SOLID_HIGH);
		}
		r.top += 18;
		r.bottom += 18;
	}

	// Now hats
	
	stick->GetHatValues(hats);
	r.top += 15;
	r.bottom = r.top + 30;
	r.left = 105;
	r.right = r.left + 30;
	for (i=0; i<numHats; i++) {
		BeginLineArray(8);
		AddLine(r.LeftTop(), r.RightTop(), rgb_black);
		AddLine(r.LeftTop(), r.LeftBottom(), rgb_black);
		AddLine(r.RightTop(), r.RightBottom(), rgb_black);
		AddLine(r.LeftBottom(), r.RightBottom(), rgb_black);
		AddLine(BPoint(r.left+10, r.top), BPoint(r.left+10, r.bottom), rgb_black);
		AddLine(BPoint(r.left+20, r.top), BPoint(r.left+20, r.bottom), rgb_black);
		AddLine(BPoint(r.left, r.top+10), BPoint(r.right, r.top+10), rgb_black);
		AddLine(BPoint(r.left, r.top+20), BPoint(r.right, r.top+20), rgb_black);
		EndLineArray();
		curHatRect.Set(r.left, r.top, r.left+10, r.top+10);
		curHatRect.OffsetBy(hatX[hats[i]], hatY[hats[i]]);
		lastHatRect.InsetBy(1,1);
		FillRect(lastHatRect, B_SOLID_LOW);
		lastHatRect = curHatRect;
		lastHatRect.InsetBy(1,1);
		FillRect(lastHatRect, B_SOLID_HIGH);
		lastHatRect.InsetBy(-1,-1);
		r.top += 40;
		r.bottom += 40;
	}
	
	// Now the joystick
	
	r.Set(200, 50, 350, 200);
	FillRect(r, B_SOLID_HIGH);
	stick->GetAxisValues(axes);
	x = axes[0];
	y = axes[1];
	SetHighColor(rgb_red);
	x += 32768;
	y -= 32768;
	x *= 0.0021362304;
	y *= 0.0021362304;
	x += 205;
	y += 195;
	FillEllipse(BPoint(x,y), 5, 5);
	SetHighColor(rgb_black);
	
	// Finally, other axes
	
	r.Set(200, 220, 350, 234);
	for (i=2; i<numAxes; i++) {
		BRect thumbRect;
		
		FillRect(r, B_SOLID_HIGH);
		x = axes[i];
		x += 32768;
		x *= 0.0021362304;
		x += 205;
		thumbRect.top = r.top;
		thumbRect.bottom = r.bottom;
		thumbRect.left = x - 3;
		thumbRect.right = x + 3;
		SetHighColor(rgb_red);
		FillRoundRect(thumbRect, 3, 3);
		SetHighColor(rgb_black);
		r.top += 18;
		r.bottom += 18;
	}
	
	free(axes);
	free(hats);
}
